/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.util.Log;
import androidx.annotation.NonNull;
import com.twilio.voice.LogModule;
import com.twilio.voice.LogParameters;
import com.twilio.voice.LoggerInterface;
import com.twilio.voice.Preconditions;

class DefaultLogger
implements LoggerInterface {
    DefaultLogger() {
    }

    @Override
    public void log(@NonNull LogParameters parameters) {
        Preconditions.checkNotNull(parameters, "LogParameters object must not be null");
        String message_prefix = "[" + this.convertModuleToString(parameters.module) + "] ";
        String tag = parameters.tag.isEmpty() ? "Twilio" : "Twilio:" + parameters.tag;
        String message = message_prefix + parameters.message;
        if (parameters.tr != null) {
            message = message + "\n" + Log.getStackTraceString((Throwable)parameters.tr);
        }
        switch (parameters.level) {
            case FATAL: 
            case ERROR: {
                Log.e((String)tag, (String)message);
                break;
            }
            case WARNING: {
                Log.w((String)tag, (String)message);
                break;
            }
            case INFO: {
                Log.i((String)tag, (String)message);
                break;
            }
            case DEBUG: {
                Log.d((String)tag, (String)message);
                break;
            }
            case TRACE: 
            case ALL: {
                Log.v((String)tag, (String)message);
                break;
            }
        }
    }

    private String convertModuleToString(LogModule module) {
        String mod = new String();
        switch (module) {
            case CORE: {
                mod = "Core";
                break;
            }
            case SIGNALING: {
                mod = "Signaling";
                break;
            }
            case WEBRTC: {
                mod = "WebRTC";
                break;
            }
            case PLATFORM: {
                mod = "Platform";
                break;
            }
        }
        return mod;
    }
}

