/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.Logger;
import com.twilio.voice.Voice;

class ConnectivityReceiver
extends BroadcastReceiver {
    private static final Logger logger = Logger.getLogger(ConnectivityReceiver.class);
    private NetworkInfo currentNetworkInfo;

    ConnectivityReceiver() {
    }

    @VisibleForTesting
    static void logNetworkChangeEvent(Voice.NetworkChangeEvent networkChangeEvent, @Nullable NetworkInfo currentNetworkInfo, @Nullable NetworkInfo newNetworkInfo, boolean reportedToSdk) {
        logger.d("networkChangeEvent: " + networkChangeEvent.name() + " reportedToSdk: " + Boolean.toString(reportedToSdk));
        logger.d("currentNetworkInfo: " + (currentNetworkInfo == null ? "null" : currentNetworkInfo.toString()));
        logger.d("newNetworkInfo: " + (newNetworkInfo == null ? "null" : newNetworkInfo.toString()));
    }

    public void onReceive(Context context, Intent intent) {
        logger.d("Network event received");
        if (intent.getAction().equalsIgnoreCase("android.net.conn.CONNECTIVITY_CHANGE")) {
            if (this.isInitialStickyBroadcast()) {
                logger.d("Ignoring network event, sticky broadcast");
                return;
            }
            ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo newNetworkInfo = conn.getActiveNetworkInfo();
            Voice.NetworkChangeEvent networkChangeEvent = Voice.NetworkChangeEvent.CONNECTION_CHANGED;
            if (newNetworkInfo != null && (this.currentNetworkInfo == null || this.currentNetworkInfo.getDetailedState() != newNetworkInfo.getDetailedState() || this.currentNetworkInfo.getType() != newNetworkInfo.getType() || this.currentNetworkInfo.getSubtype() != newNetworkInfo.getSubtype())) {
                if (!newNetworkInfo.isConnectedOrConnecting()) {
                    networkChangeEvent = Voice.NetworkChangeEvent.CONNECTION_LOST;
                }
                ConnectivityReceiver.logNetworkChangeEvent(networkChangeEvent, this.currentNetworkInfo, newNetworkInfo, true);
                Voice.onNetworkChanged(networkChangeEvent);
            } else if (newNetworkInfo == null) {
                networkChangeEvent = Voice.NetworkChangeEvent.CONNECTION_LOST;
                ConnectivityReceiver.logNetworkChangeEvent(networkChangeEvent, this.currentNetworkInfo, newNetworkInfo, true);
                Voice.onNetworkChanged(networkChangeEvent);
            } else {
                ConnectivityReceiver.logNetworkChangeEvent(networkChangeEvent, this.currentNetworkInfo, newNetworkInfo, false);
            }
            this.currentNetworkInfo = newNetworkInfo;
        }
    }
}

