/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.util.Pair;
import androidx.annotation.NonNull;
import com.twilio.voice.AudioCodec;
import com.twilio.voice.AudioOptions;
import com.twilio.voice.Call;
import com.twilio.voice.CallOptions;
import com.twilio.voice.IceOptions;
import com.twilio.voice.LocalAudioTrack;
import com.twilio.voice.PlatformInfo;
import com.twilio.voice.Preconditions;
import com.twilio.voice.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnectOptions
extends CallOptions {
    private final String accessToken;
    private final Map<String, String> params;
    private Call.EventListener eventListener;

    private ConnectOptions() {
        this.accessToken = "";
        this.params = new HashMap<String, String>();
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.audioTracks = builder.audioTracks != null ? builder.audioTracks : new ArrayList();
        this.iceOptions = builder.iceOptions;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.params = builder.params == null ? new HashMap() : builder.params;
        this.platformInfo = new PlatformInfo();
        this.eventListener = builder.eventListener;
        this.enableDscp = builder.enableDscp;
        this.enableIceGatheringOnAnyAddressPorts = builder.enableIceGatheringOnAnyAddressPorts;
        this.callMessageListener = builder.callMessageListener;
        this.audioOptions = builder.audioOptions == null ? new AudioOptions.Builder().build() : builder.audioOptions;
    }

    @NonNull
    public String getAccessToken() {
        return this.accessToken;
    }

    @NonNull
    public Map<String, String> getParams() {
        return this.params;
    }

    Call.EventListener getEventListener() {
        return this.eventListener;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        Pair<String[], String[]> paramsKeyValues = Utils.mapToArrays(this.params);
        return this.nativeCreate(this.accessToken, (String[])paramsKeyValues.first, (String[])paramsKeyValues.second, this.getLocalAudioTracksArray(), this.iceOptions, this.enableDscp, this.enableIceGatheringOnAnyAddressPorts, this.getAudioCodecsArray(), this.platformInfo);
    }

    private native long nativeCreate(String var1, String[] var2, String[] var3, LocalAudioTrack[] var4, IceOptions var5, boolean var6, boolean var7, AudioCodec[] var8, PlatformInfo var9);

    public static class Builder
    extends CallOptions.Builder {
        private final String accessToken;
        private Map<String, String> params;

        public Builder(@NonNull String accessToken) {
            Preconditions.checkNotNull(accessToken, "accessToken must not be null");
            this.accessToken = accessToken;
        }

        @NonNull
        public Builder params(@NonNull Map<String, String> params) {
            Preconditions.checkNotNull(params, "params must not be null");
            this.params = params;
            return this;
        }

        @Override
        @NonNull
        Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "audioTracks must not be null");
            super.audioTracks(audioTracks);
            return this;
        }

        @Override
        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions, "iceOptions must not be null");
            super.iceOptions(iceOptions);
            return this;
        }

        @Override
        @NonNull
        public Builder enableDscp(@NonNull boolean enable) {
            super.enableDscp(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder enableIceGatheringOnAnyAddressPorts(@NonNull boolean enable) {
            super.enableIceGatheringOnAnyAddressPorts(enable);
            return this;
        }

        @Override
        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs, "preferredAudioCodecs must not be null");
            CallOptions.checkAudioCodecs(preferredAudioCodecs);
            super.preferAudioCodecs(preferredAudioCodecs);
            return this;
        }

        @Override
        @NonNull
        public Builder callMessageListener(@NonNull Call.CallMessageListener callMessageListener) {
            return (Builder)super.callMessageListener(callMessageListener);
        }

        Builder eventListener(Call.EventListener eventListener) {
            this.eventListener = eventListener;
            return this;
        }

        @Override
        @NonNull
        public Builder audioOptions(@NonNull AudioOptions audioOptions) {
            Preconditions.checkNotNull(audioOptions, "audioOptions must not be null.");
            super.audioOptions(audioOptions);
            return this;
        }

        @NonNull
        public ConnectOptions build() {
            CallOptions.checkAudioTracksReleased(this.audioTracks);
            if (this.params != null) {
                for (Map.Entry<String, String> entry : this.params.entrySet()) {
                    Preconditions.checkState(entry.getKey() != null, "params entry key should not be null");
                    Preconditions.checkState(entry.getValue() != null, "params entry value should not be null");
                }
            }
            return new ConnectOptions(this);
        }
    }
}

