/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import com.twilio.voice.VoiceException;

public class CallException
extends VoiceException {
    public static final int EXCEPTION_INVALID_CALLER_ID = 13214;
    public static final int EXCEPTION_INVALID_PHONE_NUMBER = 13224;
    public static final int EXCEPTION_INVALID_APPLICATION_SID = 21218;
    public static final int EXCEPTION_CONNECTION_ERROR = 31005;
    public static final int EXCEPTION_CALL_CANCELLED = 31008;
    public static final int EXCEPTION_TRANSPORT_ERROR = 31009;
    public static final int EXCEPTION_RATE_EXCEEDED_AUTHORIZED_LIMIT_ERROR = 31206;
    public static final int EXCEPTION_CALL_MESSAGE_EVENT_TYPE_INVALID = 31210;
    public static final int EXCEPTION_CALL_MESSAGE_CALL_IN_UNEXPECTED_STATE_ERROR = 31211;
    public static final int EXCEPTION_CALL_MESSAGE_EVENT_PAYLOAD_SIZE_EXCEEDED_AUTHORIZED_LIMIT_ERROR = 31212;
    public static final int EXCEPTION_MALFORMED_REQUEST = 31100;
    public static final int EXCEPTION_AUTHORIZATION_ERROR = 31201;
    public static final int EXCEPTION_TEMPORARILY_UNAVAILABLE_ERROR = 31480;
    public static final int EXCEPTION_CALL_OR_TRANSACTION_DOES_NOT_EXIST_ERROR = 31481;
    public static final int EXCEPTION_ADDRESS_INCOMPLETE_ERROR = 31484;
    public static final int EXCEPTION_BUSY_HERE_ERROR = 31486;
    public static final int EXCEPTION_REQUEST_TERMINATED_ERROR = 31487;
    public static final int EXCEPTION_DNS_RESOLUTION = 31530;
    public static final int EXCEPTION_BUSY_EVERYWHERE_ERROR = 31600;
    public static final int EXCEPTION_DECLINE_ERROR = 31603;
    public static final int EXCEPTION_DOES_NOT_EXIST_ANYWHERE_ERROR = 31604;
    public static final int EXCEPTION_SIGNALING_CONNECTION_DISCONNECTED = 53001;
    public static final int EXCEPTION_CLIENT_LOCAL_MEDIA_DESCRIPTION = 53400;
    public static final int EXCEPTION_SERVER_LOCAL_MEDIA_DESCRIPTION = 53401;
    public static final int EXCEPTION_CLIENT_REMOTE_MEDIA_DESCRIPTION = 53402;
    public static final int EXCEPTION_SERVER_REMOTE_MEDIA_DESCRIPTION = 53403;
    public static final int EXCEPTION_NO_SUPPORTED_CODEC = 53404;
    public static final int EXCEPTION_MEDIA_CONNECTION_FAILED = 53405;
    public static final int EXCEPTION_MEDIA_DTLS_TRANSPORT_FAILED = 53407;
    static final CallException InvalidCallerIdException = new CallException(13214, "Invalid callerId value", "CallerId must be the calling number, called number, or a validated outgoing number.");
    static final CallException InvalidPhoneNumberException = new CallException(13224, "Invalid phone number", "Twilio does not support calling this number or the number is invalid.");
    static final CallException CallTwiMLApplicationNotFoundException = new CallException(21218, "Invalid ApplicationSid", "The server was not able to find the TwiML application associated with the App SID.");
    static final CallException CallConnectionErrorException = new CallException(31005, "Connection error", "A connection error occurred during the call.");
    static final CallException CallCancelledException = new CallException(31008, "Call Cancelled", "Unable to answer because the call has ended.");
    static final CallException TransportErrorException = new CallException(31009, "Transport error", "No transport available to send or receive messages.");
    static final CallException RateExceededAuthorizedLimitException = new CallException(31206, "Rate exceeded authorized limit", "Rate exceeded authorized limit.");
    static final CallException CallMessageEventPayloadSizeExceededException = new CallException(31212, "Call message event payload size exceeded authorized limit.", "Call message event payload size exceeded authorized limit.");
    static final CallException CallMessageEventTypeInvalidException = new CallException(31210, "Call message event type is invalid.", "Call message event type is invalid.");
    static final CallException CallMessageCallInUnexpectedStateException = new CallException(31211, "Call is not in the expected state.", "Call is not in the expected state.");
    static final CallException MalformedInvalidRequestException = new CallException(31100, "Malformed request", "The request could not be understood due to malformed syntax.");
    static final CallException AuthorizationInvalidAccessTokenException = new CallException(31201, "Authorization error", "The request requires user authentication.The server understood the request, but is refusing to fulfill it.");
    static final CallException TemporarilyUnavailableException = new CallException(31480, "Temporarily Unavailable", "The callee is currently unavailable");
    static final CallException CallDoesNotExistException = new CallException(31481, "Call/Transaction Does Not Exist", "The call no longer exists.");
    static final CallException AddressIncompleteException = new CallException(31484, "Address Incomplete", "The provided phone number is malformed.");
    static final CallException BusyHereException = new CallException(31486, "Busy Here", "The callee is busy.");
    static final CallException RequestTerminatedException = new CallException(31487, "Request Terminated", "The request has terminated as a result of a bye or cancel.");
    static final CallException DNSResolutionException = new CallException(31530, "DNS Resolution Error", "Could not connect to the server.");
    static final CallException BusyEverywhereException = new CallException(31600, "Busy Everywhere", "All possible destinations are busy.");
    static final CallException DeclineException = new CallException(31603, "Decline", "The callee does not wish to participate in the call.");
    static final CallException DoesNotExistAnywhereException = new CallException(31604, "Does Not Exist Anywhere", "The requested callee does not exist anywhere.");
    static final CallException SignalingConnectionDisconnectedErrorCode = new CallException(53001, "Signaling connection disconnected", "Raised whenever the signaling connection is unexpectedly disconnected.");
    static final CallException MediaClientLocalDescFailedErrorCode = new CallException(53400, "Client is unable to create or apply a local media description", "Raised whenever a Client is unable to create or apply a local media description.");
    static final CallException MediaServerLocalDescFailedErrorCode = new CallException(53401, "Server is unable to create or apply a local media description", "Raised whenever the Server is unable to create or apply a local media description");
    static final CallException MediaClientRemoteDescFailedErrorCode = new CallException(53402, "Client is unable to apply a remote media description", "Raised whenever the Client receives a remote media description but is unable to apply it");
    static final CallException MediaServerRemoteDescFailedErrorCode = new CallException(53403, "Server is unable to apply a remote media description", "Raised whenever the Server receives a remote media description but is unable to apply it");
    static final CallException MediaNoSupportedCodecErrorCode = new CallException(53404, "No supported code", "Raised whenever the intersection of codecs supported by the Client and the Server (or, in peer-to-peer, the Client and another Participant) is empty.");
    static final CallException MediaConnectionErrorCode = new CallException(53405, "Media connection failed", "Raised by the Client or Server whenever a media connection fails.");
    static final CallException MediaDTLSTransportErrorCode = new CallException(53407, "The media connection failed due to DTLS handshake failure", "There was a problem while negotiating with the remote DTLS peer. Therefore the Client will not be able to establish the media connection.");

    CallException(int errorCode, String errorMessage, String explanation) {
        super(errorCode, errorMessage, explanation);
    }
}

