/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.VisibleForTesting;
import com.twilio.voice.Preconditions;
import java.util.Arrays;

public class AudioFormat {
    public static final int AUDIO_SAMPLE_RATE_8000 = 8000;
    public static final int AUDIO_SAMPLE_RATE_16000 = 16000;
    public static final int AUDIO_SAMPLE_RATE_24000 = 24000;
    public static final int AUDIO_SAMPLE_RATE_32000 = 32000;
    public static final int AUDIO_SAMPLE_RATE_44100 = 44100;
    public static final int AUDIO_SAMPLE_RATE_48000 = 48000;
    public static int AUDIO_SAMPLE_MONO = 1;
    public static final int AUDIO_SAMPLE_STEREO = 2;
    @VisibleForTesting
    static final Integer[] validSampleRates = new Integer[]{8000, 16000, 24000, 32000, 44100, 48000};
    @VisibleForTesting
    static final Integer[] validChannelCounts = new Integer[]{AUDIO_SAMPLE_MONO, 2};
    private int sampleRate = -1;
    private int channelCount = -1;

    public AudioFormat(int sampleRate, int channelCount) {
        Preconditions.checkArgument(Arrays.asList(validSampleRates).contains(sampleRate), String.format("Unsupported sample rate %s", sampleRate));
        Preconditions.checkArgument(Arrays.asList(validChannelCounts).contains(channelCount), String.format("Unsupported channel count %s", channelCount));
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannelCount() {
        return this.channelCount;
    }
}

