/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.twilio.voice.AudioDevice;
import com.twilio.voice.AudioDeviceContext;
import com.twilio.voice.AudioFormat;
import com.twilio.voice.Logger;
import com.twilio.voice.ThreadUtils;
import java.nio.ByteBuffer;

class AudioDeviceProxy
extends AudioDeviceContext
implements AudioDevice {
    private static final Logger logger = Logger.getLogger(AudioDeviceProxy.class);
    private static long nativeAudioDeviceProxyHandle;
    @VisibleForTesting
    ThreadUtils.ThreadChecker threadChecker;
    private AudioDevice audioDevice;
    private boolean released = false;
    private boolean capturingStopped = false;
    private boolean renderingStopped = false;

    private AudioDeviceProxy(Context context, long nativeAudioDeviceProxy, AudioDevice audioDevice) {
        nativeAudioDeviceProxyHandle = nativeAudioDeviceProxy;
        this.audioDevice = audioDevice;
    }

    public void writeCaptureData(ByteBuffer buffer) {
        try {
            if (!this.capturingStopped && !this.released) {
                AudioDeviceProxy.nativeWriteData(nativeAudioDeviceProxyHandle, buffer, buffer.capacity());
            } else {
                logger.d("Ignoring writeCaptureData because either AudioDeviceProxy is released or capturing stopped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readRenderData(ByteBuffer buffer) {
        try {
            if (!this.renderingStopped && !this.released) {
                AudioDeviceProxy.nativeReadData(nativeAudioDeviceProxyHandle, buffer, buffer.capacity());
            } else {
                logger.d("Ignoring readRenderData because either AudioDeviceProxy is released or rendering stopped");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void release() {
        logger.d("release");
        if (!this.released) {
            if (nativeAudioDeviceProxyHandle != 0L) {
                AudioDeviceProxy.nativeRelease(nativeAudioDeviceProxyHandle);
                nativeAudioDeviceProxyHandle = 0L;
            }
            this.released = true;
        }
    }

    @Override
    public AudioFormat getCapturerFormat() {
        return null;
    }

    @Override
    public boolean onInitCapturer() {
        logger.d("onInitCapturer");
        this.checkIsOnValidThread();
        this.capturingStopped = false;
        if (!this.released) {
            try {
                this.audioDevice.onInitCapturer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean onStartCapturing(@NonNull AudioDeviceContext audioDeviceContext) {
        logger.d("onStartCapturing");
        this.checkIsOnValidThread();
        if (!this.released) {
            try {
                this.audioDevice.onStartCapturing(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean onStopCapturing() {
        logger.d("onStopCapturing");
        this.checkIsOnValidThread();
        this.capturingStopped = true;
        if (!this.released) {
            try {
                this.audioDevice.onStopCapturing();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public AudioFormat getRendererFormat() {
        return null;
    }

    @Override
    public boolean onInitRenderer() {
        logger.d("onInitRenderer");
        this.checkIsOnValidThread();
        this.renderingStopped = false;
        if (!this.released) {
            try {
                this.audioDevice.onInitRenderer();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean onStartRendering(@NonNull AudioDeviceContext audioDeviceContext) {
        logger.d("onStartRendering");
        this.checkIsOnValidThread();
        if (!this.released) {
            try {
                this.audioDevice.onStartRendering(this);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public boolean onStopRendering() {
        logger.d("onStopRendering");
        this.checkIsOnValidThread();
        this.renderingStopped = true;
        if (!this.released) {
            try {
                this.audioDevice.onStopRendering();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    void executeWorkerBlock(Runnable runnable) {
        if (this.isValid()) {
            AudioDeviceProxy.nativeExecuteWorkerBlock(nativeAudioDeviceProxyHandle, runnable);
        } else {
            logger.w("Calling executeWorkerBlock not a valid operation");
        }
    }

    void formatChanged() {
        logger.d("formatChanged");
        if (this.isValid()) {
            AudioDeviceProxy.nativeFormatChanged(nativeAudioDeviceProxyHandle, this.audioDevice.getCapturerFormat(), this.audioDevice.getRendererFormat());
        } else {
            logger.w("Calling formatChanged not a valid operation");
        }
    }

    private void checkIsOnValidThread() {
        if (this.threadChecker == null) {
            this.threadChecker = new ThreadUtils.ThreadChecker(Thread.currentThread());
        }
        this.threadChecker.checkIsOnValidThread();
    }

    private boolean isValid() {
        return !this.renderingStopped && !this.released || !this.capturingStopped && !this.released;
    }

    private static native void nativeRelease(long var0);

    private static native void nativeWriteData(long var0, ByteBuffer var2, int var3);

    private static native void nativeReadData(long var0, ByteBuffer var2, int var3);

    private static native void nativeExecuteWorkerBlock(long var0, Runnable var2);

    private static native void nativeFormatChanged(long var0, AudioFormat var2, AudioFormat var3);
}

