/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.voice;

import androidx.annotation.NonNull;
import com.twilio.voice.AudioDeviceCapturer;
import com.twilio.voice.AudioDeviceContext;
import com.twilio.voice.AudioDeviceProxy;
import com.twilio.voice.AudioDeviceRenderer;
import com.twilio.voice.Preconditions;
import java.nio.ByteBuffer;

public interface AudioDevice
extends AudioDeviceCapturer,
AudioDeviceRenderer {
    public static void audioDeviceFormatChanged(@NonNull AudioDeviceContext audioDeviceContext) {
        Preconditions.checkNotNull(audioDeviceContext, "audioDeviceContext must not be null");
        AudioDeviceProxy audioDeviceProxy = (AudioDeviceProxy)audioDeviceContext;
        audioDeviceProxy.formatChanged();
    }

    public static void audioDeviceWriteCaptureData(@NonNull AudioDeviceContext audioDeviceContext, @NonNull ByteBuffer audioSample) {
        Preconditions.checkNotNull(audioDeviceContext, "audioDeviceContext must not be null");
        Preconditions.checkNotNull(audioSample, "audioSample must not be null");
        AudioDeviceProxy audioDeviceProxy = (AudioDeviceProxy)audioDeviceContext;
        audioDeviceProxy.writeCaptureData(audioSample);
    }

    public static void audioDeviceReadRenderData(@NonNull AudioDeviceContext audioDeviceContext, @NonNull ByteBuffer audioSample) {
        Preconditions.checkNotNull(audioDeviceContext, "audioDeviceContext must not be null");
        Preconditions.checkNotNull(audioSample, "runnable must not be null");
        AudioDeviceProxy audioDeviceProxy = (AudioDeviceProxy)audioDeviceContext;
        audioDeviceProxy.readRenderData(audioSample);
    }

    public static void audioDeviceExecuteWorkerBlock(@NonNull AudioDeviceContext audioDeviceContext, @NonNull Runnable runnable) {
        Preconditions.checkNotNull(audioDeviceContext, "audioDeviceContext must not be null");
        Preconditions.checkNotNull(runnable, "runnable must not be null");
        AudioDeviceProxy audioDeviceProxy = (AudioDeviceProxy)audioDeviceContext;
        audioDeviceProxy.executeWorkerBlock(runnable);
    }
}

