package com.twilio.voice;

import androidx.annotation.NonNull;

/**
 * The Logger interface provides a mechanism to define a custom logger. Implementing this interface
 * is optional. By default, the Android SDK logs to stdout using android.util.Log. Implementing this
 * interface allows for a customized logging experience such as logging to a file, sending the log
 * messages to a server, etc.
 */
public interface LoggerInterface {
    /**
     * Invoked every time a log message satisfying the log level filter is available. If no filters
     * are set, a default filter of {@link LogLevel#ERROR} is used by the SDK on all modules.
     *
     * @param parameters A {@link LogParameters} object that contains parameters about the log
     *     message.
     */
    void log(@NonNull final LogParameters parameters);
}
