package com.twilio.voice;

import org.json.JSONObject;

class RTCStatsSample {
    private static final Logger logger = Logger.getLogger(RTCStatsSample.class);

    String timeStamp;
    String timestampMS;
    float mos;
    float fractionLost;
    Long packetsReceived;
    Long packetsLost;
    Long packetsSent;
    Long totalPacketsReceived;
    Long totalPacketsSent;
    Long totalPacketsLost;
    Long totalBytesReceived;
    Long totalBytesSent;
    Long jitter;
    Long rtt;
    Long audioInputLevel;
    Long audioOutputLevel;
    String callSid;
    String codec;
    Constants.Direction direction;

    public RTCStatsSample() {
        super();
    }

    public Long getPacketsReceived() {
        return packetsReceived;
    }

    public Long getPacketsLost() {
        return packetsLost;
    }

    public Long getPacketsSent() {
        return packetsSent;
    }

    public Long getTotalPacketsReceived() {
        return totalPacketsReceived;
    }

    public Long getTotalPacketsSent() {
        return totalPacketsSent;
    }

    public Long getTotalPacketsLost() {
        return totalPacketsLost;
    }

    public Long getTotalBytesReceived() {
        return totalBytesReceived;
    }

    public Long getTotalBytesSent() {
        return totalBytesSent;
    }

    public Long getJitter() {
        return jitter;
    }

    public Long getRtt() {
        return rtt;
    }

    public Long getAudioInputLevel() {
        return audioInputLevel == -1 ? -1 : audioInputLevel * 128;
    }

    public Long getAudioOutputLevel() {
        return audioOutputLevel == -1 ? -1 : audioOutputLevel * 128;
    }

    public String getCodec() {
        return codec;
    }

    public double getFractionLost() {
        return fractionLost;
    }

    public String getCallSid() {
        return this.callSid;
    }

    public float getMos() {
        return this.mos;
    }

    public void setCallSid(String callSid) {
        this.callSid = callSid;
    }

    public void setDirection(Constants.Direction direction) {
        this.direction = direction;
    }

    public String getTimestamp() {
        return timeStamp;
    }

    public JSONObject toJson() {
        try {
            JSONObject eventJSON = new JSONObject();

            eventJSON.put(EventKeys.TIMESTAMP, getTimestamp());
            eventJSON.put(EventKeys.TIMESTAMP_MS, getTimestampMillis());
            eventJSON.put(EventKeys.CALL_SID, getCallSid());
            eventJSON.put(EventKeys.SDK_VERSION_KEY, Voice.getVersion());

            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.PACKETS_RECEIVED, getPacketsReceived());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_LOST, getTotalPacketsLost());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.PACKETS_LOST_FRACTION, getFractionLost());
            eventJSON.put(MetricEventConstants.MetricEventKeys.PACKETS_LOST, getPacketsLost());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_SENT, getTotalPacketsSent());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.TOTAL_PACKETS_RECEIVED,
                    getTotalPacketsReceived());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.TOTAL_BYTES_RECEIVED,
                    getTotalBytesReceived());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.TOTAL_BYTES_SENT, getTotalBytesSent());
            eventJSON.put(MetricEventConstants.MetricEventKeys.JITTER, getJitter());
            eventJSON.put(MetricEventConstants.MetricEventKeys.RTT, getRtt());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.AUDIO_INPUT_LEVEL, getAudioInputLevel());
            eventJSON.put(
                    MetricEventConstants.MetricEventKeys.AUDIO_OUTPUT_LEVEL, getAudioOutputLevel());
            eventJSON.put(MetricEventConstants.MetricEventKeys.MOS, getMos());
            eventJSON.put(MetricEventConstants.MetricEventKeys.AUDIO_CODEC, getCodec());
            eventJSON.put(EventKeys.DIRECTION_KEY, this.direction);

            logger.v(eventJSON.toString());
            return eventJSON;
        } catch (Exception e) {
            logger.e(e.toString());
            return null;
        }
    }

    @Override
    public String toString() {
        return "StatsExtended [timestamp="
                + timeStamp
                + ", packetsReceived="
                + packetsReceived
                + ", packetsLost="
                + packetsLost
                + ", packetsSent="
                + packetsSent
                + ", bytesReceived="
                + totalBytesReceived
                + ", bytesSent="
                + totalBytesSent
                + ", jitter="
                + jitter
                + ", rtt="
                + rtt
                + ", audioInputLevel="
                + audioInputLevel
                + ", audioOutputLevel="
                + audioOutputLevel
                + "]";
    }

    public String getTimestampMillis() {
        return timestampMS;
    }

    public double getMosScore() {
        return this.mos;
    }
}
