package com.twilio.voice;

import android.util.Log;
import java.util.HashMap;
import java.util.Map;

/**
 * DEPRECATED - Logger class is deprecated and will be removed in the next major release. To provide
 * a custom logger, implement the {@link LoggerInterface} Interface and set it using {@link
 * com.twilio.voice.Voice#setLogger(LoggerInterface)}. The SDK will deliver all logs to this logger.
 * To use the SDK's default logger to log one's own messages, retrieve the default logger instance
 * currently being used by the SDK using {@link Voice#getLogger()} and send logs using its {@link
 * LoggerInterface#log(LogParameters)} method.
 */
@Deprecated
public final class Logger {
    public static final int INHERIT = Log.ASSERT + 1;

    private static final Map<Class<?>, Logger> loggers = new HashMap<Class<?>, Logger>();

    private static int globalLevel = Log.ERROR;
    private final String name;
    private int level = INHERIT;

    private Logger(final String name) {
        this.name = name;
    }

    public static Logger getLogger(Class<?> cls) {
        if (!loggers.containsKey(cls)) {
            synchronized (loggers) {
                if (!loggers.containsKey(cls)) {
                    loggers.put(cls, new Logger(cls.getSimpleName()));
                }
            }
        }
        return loggers.get(cls);
    }

    public static int getLogLevel() {
        return Logger.globalLevel;
    }

    public static void setLogLevel(int level) {
        Logger.globalLevel = level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public boolean isVerboseEnabled() {
        return level <= Log.VERBOSE || (level == INHERIT && globalLevel <= Log.VERBOSE);
    }

    public boolean isDebugEnabled() {
        return level <= Log.DEBUG || (level == INHERIT && globalLevel <= Log.DEBUG);
    }

    public boolean isInfoEnabled() {
        return level <= Log.INFO || (level == INHERIT && globalLevel <= Log.INFO);
    }

    public boolean isWarnEnabled() {
        return level <= Log.WARN || (level == INHERIT && globalLevel <= Log.WARN);
    }

    public boolean isErrorEnabled() {
        return level <= Log.ERROR || (level == INHERIT && globalLevel <= Log.ERROR);
    }

    public void v(final String msg, final Throwable t) {
        if (isVerboseEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.TRACE, this.name, msg).throwable(t).build();
            Voice.getLogger().log(params);
        }
    }

    public void v(final String msg) {
        if (isVerboseEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.TRACE, this.name, msg).build();
            Voice.getLogger().log(params);
        }
    }

    public void d(final String msg, final Throwable t) {
        if (isDebugEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.DEBUG, this.name, msg).throwable(t).build();
            Voice.getLogger().log(params);
        }
    }

    public void d(final String msg) {
        if (isDebugEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.DEBUG, this.name, msg).build();
            Voice.getLogger().log(params);
        }
    }

    public void i(final String msg, final Throwable t) {
        if (isInfoEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.INFO, this.name, msg).throwable(t).build();
            Voice.getLogger().log(params);
        }
    }

    public void i(final String msg) {
        if (isInfoEnabled()) {
            LogParameters params = new LogParameters.Builder(LogLevel.INFO, this.name, msg).build();
            Voice.getLogger().log(params);
        }
    }

    public void w(final String msg, final Throwable t) {
        if (isWarnEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.WARNING, this.name, msg)
                            .throwable(t)
                            .build();
            Voice.getLogger().log(params);
        }
    }

    public void w(final String msg) {
        if (isWarnEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.WARNING, this.name, msg).build();
            Voice.getLogger().log(params);
        }
    }

    public void e(final String msg, final Throwable t) {
        if (isErrorEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.ERROR, this.name, msg).throwable(t).build();
            Voice.getLogger().log(params);
        }
    }

    public void e(final String msg) {
        if (isErrorEnabled()) {
            LogParameters params =
                    new LogParameters.Builder(LogLevel.ERROR, this.name, msg).build();
            Voice.getLogger().log(params);
        }
    }
}
