package com.twilio.voice;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

abstract class Constants {
    public static int CALL_SID_LENGTH = 34;
    public static final boolean dev = true;
    private static final String KEY_NOTIFICATION_SERVICE_HOST = "notification-service";
    private static final String KEY_KIBANA_METRICS_HOST_URL = "kibana-metrics-host";
    private static final String KEY_KIBANA_EVENT_GATEWAY_HOST_URL = "kibana-event-gateway-host";
    private static final String TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL =
            "https://eventgw.twilio.com/v4/EndpointMetrics";
    private static final String TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL =
            "https://eventgw.twilio.com/v4/EndpointEvents";
    static final String TWILIO_REQUEST_HEADER = "X-Twilio-Request-Id";
    static final String TWILIO_REQUEST_SID_PREFIX = "RQ";

    private static final String DEFAULT_NOTIFICATION_SERVICE_HOST_URL = "https://ers.twilio.com";

    public static String GLOBAL_LOW_LATENCY_REGION = "gll";
    public static String EDGE_ROAMING = "roaming";
    public static String GLOBAL_ENV = "com.twilio.voice.env";
    public static String GLOBAL_ENV_SDK = "com.twilio.voice.env.sdk";

    private static Map<String, String> params = new HashMap<String, String>();

    public static final String CLIENT_SDK_PRODUCT_NAME_DEFAULT = "twilio-voice-android";
    public static final String APP_JSON_PAYLOAD_TYPE = "application/json";
    public static final String PLATFORM_ANDROID = "android";

    public enum SeverityLevel {
        INFO,
        DEBUG,
        WARNING,
        ERROR
    }

    public enum Direction {
        INCOMING,
        OUTGOING
    }

    public enum LoggerType {
        DEFAULT,
        CUSTOM
    }

    public enum CallMessageEventType {
        SENT,
        RECEIVED
    }

    public static final String getNotificationServiceUrl() {
        return params.containsKey(KEY_NOTIFICATION_SERVICE_HOST)
                ? params.get(KEY_NOTIFICATION_SERVICE_HOST)
                : DEFAULT_NOTIFICATION_SERVICE_HOST_URL;
    }

    public static final String getKeyKibanaMetricsHostUrl() {
        return params.containsKey(KEY_KIBANA_METRICS_HOST_URL)
                ? params.get(KEY_KIBANA_METRICS_HOST_URL)
                : TWILIO_DEFAULT_KIBANA_METRICS_HOST_URL;
    }

    public static final String getKeyKibanaEventGatewayHostUrl() {
        return params.containsKey(KEY_KIBANA_EVENT_GATEWAY_HOST_URL)
                ? params.get(KEY_KIBANA_EVENT_GATEWAY_HOST_URL)
                : TWILIO_DEFAULT_KIBANA_EVENT_GATEWAY_HOST_URL;
    }

    private static final void setDevParams(Map<String, String> params) {
        Constants.params = Collections.unmodifiableMap(params);
    }

    /**
     * By default, product name is set to "twilio-voice-android". If usage needs to be
     * differentiated(i.e. Flex, React Native SDK) from plain SDK usage, setting environment value
     * "com.twilio.voice.env" value to a desired value, will update the event publisher name in
     * "CLIENT_SDK_PRODUCT_NAME_DEFAULT-<desired value>" format.
     */
    static String getClientSdkProductName() {
        String env = System.getProperty(GLOBAL_ENV);
        return (null != env)
                ? String.format("%s-%s", CLIENT_SDK_PRODUCT_NAME_DEFAULT, env)
                : CLIENT_SDK_PRODUCT_NAME_DEFAULT;
    }
}
