package com.twilio.voice;

import androidx.annotation.NonNull;

public abstract class BaseTrackStats {
    /** WebRTC Track identifier */
    @NonNull public final String trackId;

    /** Total number of RTP packets lost */
    public final int packetsLost;

    /** Name of codec used for this track */
    @NonNull public final String codec;

    /** Unique name of synchronization source */
    @NonNull public final String ssrc;

    /** Unix timestamp in milliseconds */
    public final double timestamp;

    BaseTrackStats(String trackId, int packetsLost, String codec, String ssrc, double timestamp) {
        this.trackId = trackId;
        this.packetsLost = packetsLost;
        this.codec = codec;
        this.ssrc = ssrc;
        this.timestamp = timestamp;
    }
}
