/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.DataTrack;
import com.twilio.video.DataTrackPublication;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.Preconditions;
import com.twilio.video.TrackPriority;

public class LocalDataTrackPublication
implements DataTrackPublication {
    private final String sid;
    private final LocalDataTrack localDataTrack;
    private TrackPriority priority;
    private long nativeLocalDataTrackPublicationContext;

    LocalDataTrackPublication(@NonNull String sid, @NonNull LocalDataTrack localDataTrack, @NonNull TrackPriority priority, long nativeLocalDataTrackPublicationContext) {
        Preconditions.checkNotNull(sid, "SID must not be null");
        Preconditions.checkArgument(!sid.isEmpty(), "SID must not be empty");
        Preconditions.checkNotNull(localDataTrack, "Local data track must not be null");
        Preconditions.checkNotNull(priority, "priority should not be null");
        this.sid = sid;
        this.localDataTrack = localDataTrack;
        this.priority = priority;
        this.nativeLocalDataTrackPublicationContext = nativeLocalDataTrackPublicationContext;
    }

    @Override
    @NonNull
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @NonNull
    public String getTrackName() {
        return this.localDataTrack.getName();
    }

    @Override
    public boolean isTrackEnabled() {
        return this.localDataTrack.isEnabled();
    }

    @Override
    public DataTrack getDataTrack() {
        return this.localDataTrack;
    }

    @NonNull
    public LocalDataTrack getLocalDataTrack() {
        return this.localDataTrack;
    }

    @Deprecated
    @NonNull
    public TrackPriority getPriority() {
        return this.priority;
    }

    @Deprecated
    public void setPriority(TrackPriority priority) {
        this.priority = priority;
        if (!this.isReleased()) {
            this.nativeSetPriority(this.nativeLocalDataTrackPublicationContext, priority);
        }
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalDataTrackPublicationContext);
            this.nativeLocalDataTrackPublicationContext = 0L;
        }
    }

    synchronized boolean isReleased() {
        return this.nativeLocalDataTrackPublicationContext == 0L;
    }

    private native void nativeSetPriority(long var1, TrackPriority var3);

    private native void nativeRelease(long var1);
}

