/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturerObserver;
import org.jetbrains.annotations.NotNull;
import tvi.webrtc.VideoFrame;

public class VideoSink
implements tvi.webrtc.VideoSink {
    private static final Logger logger = Logger.getLogger(VideoSink.class);
    private VideoCapturerObserver videoCapturerObserver;
    private int previousWidth;
    private int previousHeight;
    private int previousRotation;
    private Handler capturerChangesHandler;
    private final Runnable notifyCapturerChanges = new Runnable(){

        @Override
        public void run() {
            if (VideoSink.this.videoCapturerObserver != null) {
                VideoSink.this.videoCapturerObserver.onCaptureParametersChanged();
            }
        }
    };

    public VideoSink(@NotNull VideoCapturerObserver videoCapturerObserver) {
        Preconditions.checkNotNull(videoCapturerObserver, "Video Capturer Observer must not be null");
        this.videoCapturerObserver = videoCapturerObserver;
        this.capturerChangesHandler = Util.createCallbackHandler();
    }

    public void resetVideoCapturerObserver() {
        this.videoCapturerObserver = null;
    }

    public void onFrame(VideoFrame videoFrame) {
        videoFrame.retain();
        int width = videoFrame.getBuffer().getWidth();
        int height = videoFrame.getBuffer().getHeight();
        int rotation = videoFrame.getRotation();
        if (this.previousHeight != height || this.previousWidth != width || this.previousRotation != rotation) {
            logger.d("Observed change in frame width from " + this.previousWidth + " to " + width + " or change in frame height from " + this.previousHeight + " to " + height + " or change in frame rotation from " + this.previousRotation + " to " + rotation);
            if (this.capturerChangesHandler != null) {
                this.capturerChangesHandler.post(this.notifyCapturerChanges);
            } else {
                logger.e("Ignoring capturer change events. Handler not available.");
            }
        }
        this.previousHeight = height;
        this.previousWidth = width;
        this.previousRotation = rotation;
        videoFrame.release();
    }
}

