/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.SinkHints;
import com.twilio.video.VideoContentPreferences;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoSinkHintsConsumer;

class VideoSinkHintsProducer {
    private final float scaleFactor;
    private VideoSinkHintsConsumer videoSinkHintsConsumer;
    private final long sinkHintsId;
    private SinkHints cachedSinkHints;

    VideoSinkHintsProducer(int densityDpi, VideoSinkHintsConsumer videoSinkHintsConsumer, long sinkHintsId, int viewVisibility, int viewWidth, int viewHeight) {
        this.videoSinkHintsConsumer = videoSinkHintsConsumer;
        this.sinkHintsId = sinkHintsId;
        this.scaleFactor = densityDpi <= 160 ? 1.0f : 1.5f;
        this.cachedSinkHints = new SinkHints(sinkHintsId, null, null);
        this.produceSinkHints(viewVisibility);
        this.produceSinkHints(viewWidth, viewHeight);
    }

    void produceSinkHints(int viewVisibility) {
        if (this.videoSinkHintsConsumer != null && this.videoSinkHintsConsumer.isClientTrackSwitchAutoModeEnabled()) {
            SinkHints sinkHints;
            this.cachedSinkHints = sinkHints = new SinkHints(this.sinkHintsId, viewVisibility == 0, this.cachedSinkHints.getVideoContentPreferences());
            this.videoSinkHintsConsumer.consumeSinkHints(sinkHints);
        }
    }

    void produceSinkHints(int width, int height) {
        if (this.videoSinkHintsConsumer != null && this.videoSinkHintsConsumer.isVideoContentPreferencesAutoModeEnabled()) {
            SinkHints sinkHints;
            VideoContentPreferences videoContentPreferences = this.getScaledVideoContentPreferences(width, height);
            this.cachedSinkHints = sinkHints = new SinkHints(this.sinkHintsId, this.cachedSinkHints.isEnabled(), videoContentPreferences);
            this.videoSinkHintsConsumer.consumeSinkHints(sinkHints);
        }
    }

    long getSinkHintsId() {
        return this.sinkHintsId;
    }

    private VideoContentPreferences getScaledVideoContentPreferences(int width, int height) {
        int scaledWidth = Math.round((float)width * this.scaleFactor);
        int scaledHeight = Math.round((float)height * this.scaleFactor);
        VideoDimensions videoDimensions = new VideoDimensions(scaledWidth, scaledHeight);
        return new VideoContentPreferences(videoDimensions);
    }
}

