package com.twilio.video;

/** VideoEncodingMode describes how publishers manage video codecs and video encodings. */
public enum VideoEncodingMode {
    /**
     * Twilio's SDKs and Servers select video codecs and manage video encodings automatically.
     *
     * <p>- The publisher prefers scalable video codecs in Group Rooms, and disables scalability
     * features that are not needed in Peer-to-Peer and Go Rooms.
     *
     * <p>- In Group Rooms, the publisher reduces resource usage by only sending the encodings that
     * are needed by subscribers or by the media server (when recording is enabled).
     *
     * <p>- If there are no subscribers, and recording is disabled then all track encodings are
     * suspended.
     */
    AUTO
}
