package com.twilio.video;

/**
 * TrackSwitchOffMode represents the possible modes of behavior of the Track switch-off mechanism.
 */
public enum TrackSwitchOffMode {
    /** In this mode, Tracks are never switched off. */
    DISABLED,

    /**
     * In this mode, Tracks are pro-actively switched off when network congestion is predicted by
     * the bandwidth estimation mechanism.
     */
    PREDICTED,

    /** In this mode, Tracks are switched off only when network congestion is detected. */
    DETECTED
}
