package com.twilio.video;

import androidx.annotation.NonNull;
import java.nio.ByteBuffer;
import tvi.webrtc.JavaI420Buffer;
import tvi.webrtc.VideoFrame;

/** A frame buffer that represents an image in the ARGB format with 8 bits of of precision. */
public class Rgba8888Buffer implements VideoFrame.Buffer {
    private final ByteBuffer data;
    private final int width;
    private final int height;

    public Rgba8888Buffer(@NonNull ByteBuffer data, int width, int height) {
        this.data = data;
        this.width = width;
        this.height = height;
    }

    /** Returns the raw frame buffer data. */
    public ByteBuffer getData() {
        return data;
    }

    /** Returns the frame width. */
    @Override
    public int getWidth() {
        return width;
    }

    /** Returns the frame height. */
    @Override
    public int getHeight() {
        return height;
    }

    /**
     * Converts the buffer to a {@link tvi.webrtc.VideoFrame.I420Buffer}.
     *
     * @return a copy of the original buffer converted to an I420 buffer.
     */
    @Override
    public VideoFrame.I420Buffer toI420() {
        return (VideoFrame.I420Buffer) cropAndScale(0, 0, width, height, width, height);
    }

    @Override
    public void retain() {}

    @Override
    public void release() {}

    @Override
    public VideoFrame.Buffer cropAndScale(
            int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        JavaI420Buffer newBuffer = JavaI420Buffer.allocate(scaleWidth, scaleHeight);
        nativeCropAndScale(
                cropX,
                cropY,
                cropWidth,
                cropHeight,
                scaleWidth,
                scaleHeight,
                this.data.array(),
                this.width,
                this.height,
                newBuffer.getDataY(),
                newBuffer.getStrideY(),
                newBuffer.getDataU(),
                newBuffer.getStrideU(),
                newBuffer.getDataV(),
                newBuffer.getStrideV());
        return newBuffer;
    }

    private static native void nativeCropAndScale(
            int cropX,
            int cropY,
            int cropWidth,
            int cropHeight,
            int scaleWidth,
            int scaleHeight,
            byte[] src,
            int srcWidth,
            int srcHeight,
            ByteBuffer dstY,
            int dstStrideY,
            ByteBuffer dstU,
            int dstStrideU,
            ByteBuffer dstV,
            int dstStrideV);
}
