package com.twilio.video;

/**
 * BandwidthProfileMode specifies how {@link RemoteVideoTrack}(s) {@link TrackPriority} values are
 * mapped to bandwidth allocation in Group Rooms.
 */
public enum BandwidthProfileMode {
    /**
     * This mode is for use cases where some {@link RemoteVideoTrack}(s) are more prioritized over
     * others. However, the lower priority {@link RemoteVideoTrack}(s) still need to be visible. The
     * bandwidth allocation algorithm will distribute the available downlink bandwidth proportional
     * to the requested render {@link VideoDimensions}. In case of low downlink bandwidth, the
     * quality of higher priority {@link RemoteVideoTrack}(s) may be degraded to avoid switching off
     * lower priority {@link RemoteVideoTrack}(s).
     */
    COLLABORATION,

    /**
     * This mode is for use cases where all the subscribed {@link RemoteVideoTrack}(s) are equally
     * important. The bandwidth allocation algorithm will share the available downlink bandwidth
     * equally among the subscribed {@link RemoteVideoTrack}(s).
     */
    GRID,

    /**
     * This mode is for use cases where some {@link RemoteVideoTrack}(s) are deemed critical and
     * must be preserved at any cost over the other {@link RemoteVideoTrack}(s). The bandwidth
     * allocation algorithm will allocate as big a share of the available downlink bandwidth as it
     * possibly can to the higher priority {@link RemoteVideoTrack}(s), and only then consider the
     * lower priority {@link RemoteVideoTrack}(s). In case of low downlink bandwidth, the lower
     * priority {@link RemoteVideoTrack}(s) are switched off in order to preserve the quality of the
     * higher priority {@link RemoteVideoTrack}(s).
     */
    PRESENTATION
}
