package com.twilio.video;

import androidx.annotation.NonNull;

/** Represents the format of a video frame. */
public class VideoFormat {
    @NonNull public final VideoDimensions dimensions;
    public final int framerate;

    public VideoFormat(@NonNull VideoDimensions dimensions, int framerate) {
        this.dimensions = dimensions;
        this.framerate = framerate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VideoFormat that = (VideoFormat) o;

        if (framerate != that.framerate) return false;
        return dimensions.equals(that.dimensions);
    }

    @Override
    public int hashCode() {
        int result = dimensions.hashCode();
        result = 31 * result + framerate;
        return result;
    }
}
