/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Camera2Utils;
import com.twilio.video.CaptureRequestUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.TwilioException;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoFrameProcessor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import tvi.webrtc.Camera2Enumerator;
import tvi.webrtc.Camera2Session;
import tvi.webrtc.CameraVideoCapturer;
import tvi.webrtc.CapturerObserver;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoFrame;

public class Camera2Capturer
implements VideoCapturer {
    private static final String CAMERA_SWITCH_PENDING_ERROR_MESSAGE = "Camera switch already in progress.";
    private static final Logger logger = Logger.getLogger(Camera2Capturer.class);
    private final Object stateLock = new Object();
    private State state = State.IDLE;
    private final Context applicationContext;
    private final Camera2Enumerator camera2Enumerator;
    private final AtomicBoolean captureRequestUpdatePending = new AtomicBoolean(false);
    private CaptureRequestUpdater captureRequestUpdater;
    @Nullable
    private final Listener listener;
    private final Handler handler;
    private String cameraId;
    private CapturerObserver capturerObserver;
    private tvi.webrtc.Camera2Capturer webrtcCamera2Capturer;
    private Camera2Session camera2Session;
    private String pendingCameraId;
    private VideoFrameProcessor videoFrameProcessor;
    private final CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        public void onCameraError(String errorMessage) {
            Camera2Capturer.this.reportError(new Exception(2, errorMessage));
        }

        public void onCameraDisconnected() {
        }

        public void onCameraFreezed(String errorMessage) {
            Camera2Capturer.this.reportError(new Exception(0, errorMessage));
        }

        public void onCameraOpening(String s) {
        }

        public void onFirstFrameAvailable() {
            Camera2Capturer.this.setSession();
            Camera2Capturer.this.handler.post(() -> {
                if (Camera2Capturer.this.listener != null) {
                    Camera2Capturer.this.listener.onFirstFrameAvailable();
                }
            });
        }

        public void onCameraClosed() {
            Camera2Capturer.this.setSession();
        }
    };
    private final CapturerObserver observerAdapter = new CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            if (success) {
                Object object = Camera2Capturer.this.stateLock;
                synchronized (object) {
                    if (Camera2Capturer.this.state == State.STARTING) {
                        Camera2Capturer.this.setSession();
                        Camera2Capturer.this.state = State.RUNNING;
                        if (Camera2Capturer.this.captureRequestUpdater != null) {
                            Camera2Capturer.this.updateCaptureRequestOnCameraThread(Camera2Capturer.this.captureRequestUpdater);
                            Camera2Capturer.this.captureRequestUpdater = null;
                        }
                    } else {
                        logger.w("Attempted to transition from " + (Object)((Object)Camera2Capturer.this.state) + " to RUNNING");
                    }
                }
            } else {
                logger.e("Failed to start capturer");
            }
            if (success && null != Camera2Capturer.this.videoFrameProcessor) {
                Camera2Capturer.this.videoFrameProcessor.onCaptureStarted();
            }
            Camera2Capturer.this.capturerObserver.onCapturerStarted(success);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStopped() {
            Object object = Camera2Capturer.this.stateLock;
            synchronized (object) {
                Camera2Capturer.this.state = State.IDLE;
            }
            if (null != Camera2Capturer.this.videoFrameProcessor) {
                Objects.requireNonNull(Camera2Capturer.this.webrtcCamera2Capturer.getHandler()).post(() -> Camera2Capturer.this.videoFrameProcessor.onCaptureStoped());
            }
            Camera2Capturer.this.capturerObserver.onCapturerStopped();
        }

        public void onFrameCaptured(VideoFrame videoFrame) {
            if (null != Camera2Capturer.this.videoFrameProcessor) {
                Camera2Capturer.this.videoFrameProcessor.onFrame(videoFrame, Camera2Capturer.this.capturerObserver);
            } else {
                Camera2Capturer.this.capturerObserver.onFrameCaptured(videoFrame);
            }
        }
    };
    private final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            Camera2Capturer camera2Capturer = Camera2Capturer.this;
            synchronized (camera2Capturer) {
                Camera2Capturer.this.cameraId = Camera2Capturer.this.pendingCameraId;
                Camera2Capturer.this.pendingCameraId = null;
            }
            Camera2Capturer.this.handler.post(() -> {
                if (Camera2Capturer.this.listener != null) {
                    Camera2Capturer.this.listener.onCameraSwitched(Camera2Capturer.this.cameraId);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera with ID: " + Camera2Capturer.this.pendingCameraId);
            Camera2Capturer camera2Capturer = Camera2Capturer.this;
            synchronized (camera2Capturer) {
                Camera2Capturer.this.pendingCameraId = null;
            }
            Camera2Capturer.this.reportError(new Exception(1, errorMessage));
        }
    };

    public static boolean isSupported(@NonNull Context context) {
        Preconditions.checkNotNull(context, "Context must not be null");
        return Camera2Enumerator.isSupported((Context)context);
    }

    public Camera2Capturer(@NonNull Context context, @NonNull String cameraId) {
        this(context, cameraId, null, null, Util.createCallbackHandler());
    }

    public Camera2Capturer(@NonNull Context context, @NonNull String cameraId, @Nullable Listener listener) {
        this(context, cameraId, listener, null, Util.createCallbackHandler());
    }

    public Camera2Capturer(@NonNull Context context, @NonNull String cameraId, @Nullable VideoFrameProcessor videoFrameProcessor, @Nullable Listener listener) {
        this(context, cameraId, listener, videoFrameProcessor, Util.createCallbackHandler());
    }

    @VisibleForTesting
    Camera2Capturer(@NonNull Context context, @NonNull String cameraId, @Nullable Listener listener, @Nullable VideoFrameProcessor videoFrameProcessor, @NonNull Handler handler) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkState(Camera2Capturer.isSupported(context), "Camera2Capturer is not supported on this device");
        Preconditions.checkNotNull(cameraId, "Camera ID must not be null");
        Preconditions.checkArgument(!cameraId.isEmpty(), "Camera ID must not be empty");
        this.applicationContext = context.getApplicationContext();
        this.camera2Enumerator = new Camera2Enumerator(this.applicationContext);
        this.cameraId = cameraId;
        this.listener = listener;
        this.videoFrameProcessor = videoFrameProcessor;
        this.handler = handler;
    }

    public boolean isScreencast() {
        return false;
    }

    public void initialize(@NonNull SurfaceTextureHelper surfaceTextureHelper, @NonNull Context context, @NonNull CapturerObserver capturerObserver) {
        if (null == this.webrtcCamera2Capturer) {
            this.capturerObserver = capturerObserver;
            this.webrtcCamera2Capturer = (tvi.webrtc.Camera2Capturer)this.camera2Enumerator.createCapturer(this.cameraId, this.cameraEventsHandler);
            this.webrtcCamera2Capturer.initialize(surfaceTextureHelper, context, this.observerAdapter);
        } else {
            logger.w("attempted to initialize capturing when capturer is starting or running, resetting capturer.");
            this.dispose();
            this.initialize(surfaceTextureHelper, context, capturerObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(int width, int height, int framerate) {
        this.checkCapturerState();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.IDLE || this.state == State.STOPPING) {
                logger.i("startCapture");
                this.state = State.STARTING;
                this.webrtcCamera2Capturer.startCapture(width, height, framerate);
            } else if (this.state == State.STARTING || this.state == State.RUNNING) {
                logger.w("attempted to start capturing when capturer is starting or running");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture() {
        if (this.webrtcCamera2Capturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STOPPING;
            }
            this.webrtcCamera2Capturer.stopCapture();
        }
    }

    @Override
    public void dispose() {
        if (this.webrtcCamera2Capturer != null) {
            this.webrtcCamera2Capturer.dispose();
            this.webrtcCamera2Capturer = null;
        }
    }

    @NonNull
    public synchronized String getCameraId() {
        return this.cameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchCamera(@NonNull String newCameraId) {
        Preconditions.checkNotNull(newCameraId, "Camera ID must not be null");
        Preconditions.checkArgument(!newCameraId.isEmpty(), "Camera ID must not be empty");
        Preconditions.checkArgument(!newCameraId.equals(this.cameraId), "Camera ID must be different from current camera ID");
        Preconditions.checkArgument(Camera2Utils.cameraIdSupported(this.applicationContext, newCameraId), "Camera ID %s is not supported or could not be validated", (Object)newCameraId);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                if (this.pendingCameraId == null) {
                    this.pendingCameraId = newCameraId;
                    if (null != this.videoFrameProcessor) {
                        Objects.requireNonNull(this.webrtcCamera2Capturer.getHandler()).post(() -> this.videoFrameProcessor.onCaptureStoped());
                    }
                    this.webrtcCamera2Capturer.switchCamera(this.cameraSwitchHandler, newCameraId);
                } else {
                    this.handler.post(() -> this.reportError(new Exception(1, CAMERA_SWITCH_PENDING_ERROR_MESSAGE)));
                }
            } else {
                this.cameraId = newCameraId;
                if (this.listener != null) {
                    this.listener.onCameraSwitched(this.cameraId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCaptureRequest(@NonNull CaptureRequestUpdater captureRequestUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.captureRequestUpdatePending.get()) {
                    this.captureRequestUpdatePending.set(true);
                    return this.webrtcCamera2Capturer.getHandler().post(() -> this.updateCaptureRequestOnCameraThread(captureRequestUpdater));
                }
                logger.w("Parameters will not be applied with parameter update pending");
                return false;
            }
            logger.i("Camera2Capturer is not running. The CaptureRequest update will be applied when it is resumed");
            this.captureRequestUpdater = captureRequestUpdater;
            return true;
        }
    }

    private void setSession() {
        logger.d("Camera capture session configured");
        this.camera2Session = this.webrtcCamera2Capturer != null ? (Camera2Session)this.webrtcCamera2Capturer.getCameraSession() : null;
    }

    private void checkCapturerState() {
        Preconditions.checkState(Util.permissionGranted(this.applicationContext, "android.permission.CAMERA"), "CAMERA permission must be granted to create videotrack with Camera2Capturer");
        Preconditions.checkState(Camera2Utils.cameraIdSupported(this.applicationContext, this.cameraId), "Camera ID %s is not supported or could not be validated", (Object)this.cameraId);
    }

    private void reportError(Exception camera2Exception) {
        logger.e(camera2Exception.getMessage(), camera2Exception);
        this.handler.post(() -> {
            if (this.listener != null) {
                this.listener.onError(camera2Exception);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCaptureRequestOnCameraThread(@NonNull CaptureRequestUpdater captureRequestUpdater) {
        Preconditions.checkNotNull(captureRequestUpdater, "captureRequestUpdate must not be null");
        this.setSession();
        Object object = this.stateLock;
        synchronized (object) {
            if (null != this.camera2Session) {
                if (this.state == State.RUNNING) {
                    logger.i("Applying custom capture request");
                    CaptureRequest.Builder captureRequestBuilder = this.camera2Session.configureCaptureRequestBuilder();
                    if (captureRequestBuilder == null) {
                        this.reportError(new Exception(3, "Failed to create capture request builder"));
                        this.captureRequestUpdatePending.set(false);
                        return;
                    }
                    captureRequestUpdater.apply(captureRequestBuilder);
                    boolean succeeded = this.camera2Session.setSessionRepeatingRequest(captureRequestBuilder);
                    if (!succeeded) {
                        this.reportError(new Exception(3, "Failed to set session repeating request"));
                        this.captureRequestUpdatePending.set(false);
                        return;
                    }
                } else {
                    logger.w("Attempted to update camera parameters while camera capturer is not running");
                }
                this.captureRequestUpdatePending.set(false);
            }
        }
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched(@NonNull String var1);

        public void onError(@NonNull Exception var1);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static class Exception
    extends TwilioException {
        public static final int CAMERA_FROZE = 0;
        public static final int CAMERA_SWITCH_FAILED = 1;
        public static final int UNKNOWN = 2;
        public static final int CAPTURE_REQUEST_UPDATE_FAILED = 3;

        @SuppressLint(value={"WrongConstant"})
        Exception(int code, @NonNull String message, @Nullable String explanation) {
            super(code, message, explanation);
        }

        Exception(int code, @NonNull String message) {
            this(code, message, null);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface Code {
        }
    }
}

