package com.twilio.video;

import androidx.annotation.NonNull;

/**
 * Traditional block-based transform coding format similar to H264.
 *
 * @see <a href="https://en.wikipedia.org/wiki/VP8">VP8</a>
 */
public class Vp8Codec extends VideoCodec {
    @NonNull public static final String NAME = "VP8";

    /**
     * Enabling simulcast causes the encoder to generate multiple spatial and temporal layers for
     * the video that is published. This feature should only be enabled in a Group Room.
     */
    public final boolean simulcast;

    public Vp8Codec() {
        this(false);
    }

    public Vp8Codec(boolean simulcast) {
        super(NAME);
        this.simulcast = simulcast;
    }
}
