package com.twilio.video;

final class PlatformInfo {
    private static final String PLATFORM_NAME = "Android";
    private static long nativeHandle = 0;
    public static String PRODUCT_NAME_PROPERTY = "com.twilio.video.product.name";
    public static String PRODUCT_VERSION_PROPERTY = "com.twilio.video.product.version";

    private PlatformInfo() {}

    static synchronized long getNativeHandle() {
        if (nativeHandle == 0) {
            nativeHandle =
                    nativeCreate(
                            getProductName(),
                            android.os.Build.VERSION.RELEASE,
                            android.os.Build.MANUFACTURER,
                            android.os.Build.MODEL,
                            getProductVersion(),
                            System.getProperty("os.arch"));
        }
        return nativeHandle;
    }

    static synchronized void release() {
        if (nativeHandle != 0) {
            nativeRelease(nativeHandle);
            nativeHandle = 0;
        }
    }

    private static String getProductName() {
        String productName = System.getProperty(PRODUCT_NAME_PROPERTY);
        return (null != productName && !productName.isEmpty())
                ? PLATFORM_NAME + "-" + productName
                : PLATFORM_NAME;
    }

    private static String getProductVersion() {
        return System.getProperty(PRODUCT_VERSION_PROPERTY, Video.getVersion());
    }

    private static native long nativeCreate(
            String platformName,
            String platformVersion,
            String hwDeviceManufacturer,
            String hwDeviceModel,
            String sdkVersion,
            String hwDeviceArch);

    private static native void nativeRelease(long nativeHandle);
}
