package com.twilio.video;

/**
 * Configures the mode for switching off/on subscribed {@link RemoteVideoTrack}s based on the
 * subscriber's rendering environment. Switching off a {@link RemoteVideoTrack} means no media is
 * sent by the media server to the client for that track even though it has been subscribed to by
 * the client. This feature helps in conserving network bandwidth and CPU resources by avoiding
 * unnecessary transmission and decoding of remote tracks. This feature supersedes the `maxTracks`
 * parameter. Attempting to set `clientTrackSwitchOffControl` when `maxTracks` is already set will
 * throw an exception.
 */
public enum ClientTrackSwitchOffControl {
    /**
     * In this mode, the SDK determines whether {@link RemoteVideoTrack}s should be switched off
     * based on {@link tvi.webrtc.VideoSink} attachment and {@link android.view.View} visibility.
     * Only {@link VideoTextureView}s and {@link VideoView}s are supported. If a custom {@link
     * tvi.webrtc.VideoSink}s is added to the {@link RemoteVideoTrack}, then this mode will be
     * disabled and the track will remain switched on until the sink is removed from the track.
     */
    AUTO,

    /**
     * In this mode, the application requests that specific {@link RemoteVideoTrack}s be switched
     * off or on using the {@link RemoteVideoTrack#switchOff()}/{@link RemoteVideoTrack#switchOn()}
     * methods on the {@link RemoteVideoTrack}.
     */
    MANUAL
}
