package com.twilio.video;

import androidx.annotation.VisibleForTesting;
import java.util.HashSet;
import java.util.Set;
import tvi.webrtc.EglBase;

class EglBaseProvider {
    private static final String RELEASE_MESSAGE_TEMPLATE =
            "EglBaseProvider released %s " + "unavailable";
    private static volatile EglBaseProvider instance;
    private static volatile Set<Object> eglBaseProviderOwners = new HashSet<>();

    private EglBase rootEglBase;

    static EglBaseProvider instance(Object owner) {
        synchronized (EglBaseProvider.class) {
            if (instance == null) {
                instance = new EglBaseProvider();
            }
            eglBaseProviderOwners.add(owner);

            return instance;
        }
    }

    EglBase getRootEglBase() {
        synchronized (EglBaseProvider.class) {
            checkReleased("getRootEglBase");
            return instance.rootEglBase;
        }
    }

    void release(Object owner) {
        synchronized (EglBaseProvider.class) {
            eglBaseProviderOwners.remove(owner);
            if (instance != null && eglBaseProviderOwners.isEmpty()) {
                instance.rootEglBase.release();
                instance.rootEglBase = null;
                instance = null;
            }
        }
    }

    @VisibleForTesting(otherwise = VisibleForTesting.NONE)
    static void waitForNoOwners() {
        while (true) {
            synchronized (EglBaseProvider.class) {
                if (eglBaseProviderOwners.isEmpty()) {
                    break;
                }
            }
        }
    }

    private EglBaseProvider() {
        rootEglBase = EglBase.create();
    }

    private void checkReleased(String methodName) {
        if (instance == null) {
            String releaseErrorMessage = String.format(RELEASE_MESSAGE_TEMPLATE, methodName);

            throw new IllegalStateException(releaseErrorMessage);
        }
    }
}
