/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tvi.webrtc.VideoSink;

public abstract class VideoTrack
implements Track {
    private static final Logger logger = Logger.getLogger(VideoTrack.class);
    private Set<VideoSink> videoSinks = new HashSet<VideoSink>();
    private final tvi.webrtc.VideoTrack webRtcVideoTrack;
    private final String name;
    private boolean isEnabled;
    private boolean isReleased = false;

    VideoTrack(@NonNull tvi.webrtc.VideoTrack webRtcVideoTrack, boolean enabled, @NonNull String name) {
        this.isEnabled = enabled;
        this.name = name;
        this.webRtcVideoTrack = webRtcVideoTrack;
    }

    public synchronized void addSink(@NonNull VideoSink videoSink) {
        Preconditions.checkNotNull(videoSink, "Video sink must not be null");
        if (!this.isReleased) {
            this.videoSinks.add(videoSink);
            this.webRtcVideoTrack.addSink(videoSink);
        } else {
            logger.w("Attempting to add sink to track that has been removed");
        }
    }

    public synchronized void removeSink(@NonNull VideoSink videoSink) {
        Preconditions.checkNotNull(videoSink, "Video sink must not be null");
        if (!this.isReleased) {
            this.webRtcVideoTrack.removeSink(videoSink);
            this.videoSinks.remove(videoSink);
        } else {
            logger.w("Attempting to remove sink from track that has been removed");
        }
    }

    @NonNull
    public synchronized List<VideoSink> getSinks() {
        return new ArrayList<VideoSink>(this.videoSinks);
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    synchronized void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    synchronized void release() {
        if (!this.isReleased) {
            this.invalidateWebRtcTrack();
            this.videoSinks.clear();
            this.isReleased = true;
        }
    }

    synchronized boolean isReleased() {
        return this.isReleased;
    }

    synchronized void invalidateWebRtcTrack() {
        if (this.webRtcVideoTrack != null) {
            for (VideoSink videoSink : this.videoSinks) {
                this.webRtcVideoTrack.removeSink(videoSink);
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    synchronized tvi.webrtc.VideoTrack getWebRtcTrack() {
        return this.webRtcVideoTrack;
    }

    Set<VideoSink> getVideoSinks() {
        return this.videoSinks;
    }
}

