package com.twilio.video;

import androidx.annotation.NonNull;

/**
 * Lossy audio coding format.
 *
 * @see <a href="https://en.wikipedia.org/wiki/Opus_(audio_format)">Opus</a>
 */
public class OpusCodec extends AudioCodec {
    @NonNull public static final String NAME = "opus";
    private final boolean useDtx;

    public OpusCodec() {
        this(true);
    }

    /**
     * A constructor to initialize the OpusCodec with non-default attributes.
     *
     * @param useDtx Discontinuous transmission reduces the bitrate for certain input signals, like
     *     periods of silence [RFC-7587 3.1.3](https://tools.ietf.org/html/rfc7587#section-3.1.3).
     *     The default is false. This setting applies to sender and receiver transmission.
     */
    public OpusCodec(boolean useDtx) {
        super(NAME);
        this.useDtx = useDtx;
    }

    /**
     * Reports whether DTX is enabled or not.
     *
     * @return true if DTX is enabled.
     */
    public boolean isDtxEnabled() {
        return useDtx;
    }
}
