/*
 * Copyright (C) 2017 Twilio, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.twilio.video;

import androidx.annotation.NonNull;

/** Represents the format of a video frame. */
public class VideoFormat {
    @NonNull public final VideoDimensions dimensions;
    public final int framerate;

    public VideoFormat(@NonNull VideoDimensions dimensions, int framerate) {
        this.dimensions = dimensions;
        this.framerate = framerate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        VideoFormat that = (VideoFormat) o;

        if (framerate != that.framerate) return false;
        return dimensions.equals(that.dimensions);
    }

    @Override
    public int hashCode() {
        int result = dimensions.hashCode();
        result = 31 * result + framerate;
        return result;
    }
}
