/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Preconditions;
import tvi.webrtc.VideoDecoderFactory;
import tvi.webrtc.VideoEncoderFactory;

@VisibleForTesting(otherwise=5)
class MediaOptions {
    @Nullable
    private final String audioFilePath;
    @Nullable
    final VideoEncoderFactory videoEncoderFactory;
    @Nullable
    final VideoDecoderFactory videoDecoderFactory;

    private MediaOptions(Builder builder) {
        this.audioFilePath = builder.audioFilePath;
        this.videoEncoderFactory = builder.videoEncoderFactory;
        this.videoDecoderFactory = builder.videoDecoderFactory;
    }

    static class Builder {
        @Nullable
        private String audioFilePath;
        @Nullable
        private VideoEncoderFactory videoEncoderFactory;
        @Nullable
        private VideoDecoderFactory videoDecoderFactory;

        Builder() {
        }

        Builder audioFilePath(@NonNull String audioFilePath) {
            Preconditions.checkNotNull("audioFilePath should not be null", audioFilePath);
            this.audioFilePath = audioFilePath;
            return this;
        }

        Builder videoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
            this.videoEncoderFactory = videoEncoderFactory;
            return this;
        }

        Builder videoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
            this.videoDecoderFactory = videoDecoderFactory;
            return this;
        }

        MediaOptions build() {
            return new MediaOptions(this);
        }
    }
}

