/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.hardware.Camera;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.CameraParameterUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import tvi.webrtc.Camera1Capturer;
import tvi.webrtc.Camera1Enumerator;
import tvi.webrtc.Camera1Session;
import tvi.webrtc.CameraEnumerationAndroid;
import tvi.webrtc.CameraVideoCapturer;
import tvi.webrtc.CapturerObserver;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.ThreadUtils;
import tvi.webrtc.VideoFrame;

public class CameraCapturer
implements VideoCapturer {
    private static final int CAMERA_CLOSED_TIMEOUT_MS = 3000;
    private static final String ERROR_MESSAGE_CAMERA_SERVER_DIED = "Camera server died!";
    private static final String ERROR_MESSAGE_UNKNOWN = "Camera error:";
    private static final Logger logger = Logger.getLogger(CameraCapturer.class);
    public static final int ERROR_CAMERA_FREEZE = 0;
    public static final int ERROR_CAMERA_SERVER_STOPPED = 1;
    public static final int ERROR_UNSUPPORTED_SOURCE = 2;
    public static final int ERROR_CAMERA_PERMISSION_NOT_GRANTED = 3;
    public static final int ERROR_CAMERA_SWITCH_FAILED = 5;
    public static final int ERROR_UNKNOWN = 6;
    private final Object stateLock = new Object();
    private State state = State.IDLE;
    private final Context context;
    private final Camera1Enumerator camera1Enumerator;
    private final AtomicBoolean parameterUpdatePending = new AtomicBoolean(false);
    private Listener listener;
    private final Handler handler;
    @VisibleForTesting
    Camera1Capturer webRtcCameraCapturer;
    private String cameraId;
    private String pendingCameraId;
    private Camera1Session camera1Session;
    private CapturerObserver capturerObserver;
    private final CapturerObserver observerAdapter = new CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            if (success) {
                Object object = CameraCapturer.this.stateLock;
                synchronized (object) {
                    if (CameraCapturer.this.state == State.STARTING) {
                        CameraCapturer.this.camera1Session = (Camera1Session)CameraCapturer.this.webRtcCameraCapturer.getCameraSession();
                        CameraCapturer.this.state = State.RUNNING;
                        if (CameraCapturer.this.cameraParameterUpdater != null) {
                            CameraCapturer.this.updateCameraParametersOnCameraThread(CameraCapturer.this.cameraParameterUpdater);
                            CameraCapturer.this.cameraParameterUpdater = null;
                        }
                    } else {
                        logger.w("Attempted to transition from " + (Object)((Object)CameraCapturer.this.state) + " to RUNNING");
                    }
                }
            } else {
                logger.e("Failed to start capturer");
            }
            CameraCapturer.this.capturerObserver.onCapturerStarted(success);
        }

        public void onCapturerStopped() {
            CameraCapturer.this.capturerObserver.onCapturerStopped();
        }

        public void onFrameCaptured(VideoFrame videoFrame) {
            CameraCapturer.this.capturerObserver.onFrameCaptured(videoFrame);
        }
    };
    private CameraParameterUpdater cameraParameterUpdater;
    private CountDownLatch cameraClosed;
    private final CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraError(String errorMsg) {
            if (CameraCapturer.this.listener != null) {
                if (errorMsg.equals(CameraCapturer.ERROR_MESSAGE_CAMERA_SERVER_DIED)) {
                    logger.e("Camera server stopped.");
                    CameraCapturer.this.listener.onError(1);
                } else if (errorMsg.contains(CameraCapturer.ERROR_MESSAGE_UNKNOWN)) {
                    logger.e("Unknown camera error occurred.");
                    CameraCapturer.this.listener.onError(6);
                }
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraFreezed(String s) {
            logger.e("Camera froze.");
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(0);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        public void onCameraOpening(String message) {
        }

        public void onFirstFrameAvailable() {
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onFirstFrameAvailable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraClosed() {
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.state == State.STOPPING) {
                    CameraCapturer.this.camera1Session = null;
                    CameraCapturer.this.cameraClosed.countDown();
                }
            }
        }

        public void onCameraDisconnected() {
        }
    };
    private final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                CameraCapturer.this.cameraId = CameraCapturer.this.pendingCameraId;
                CameraCapturer.this.pendingCameraId = null;
            }
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onCameraSwitched(CameraCapturer.this.cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera source " + CameraCapturer.this.cameraId);
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(5);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }
    };

    public CameraCapturer(@NonNull Context context, @NonNull String cameraId) {
        this(context, cameraId, null);
    }

    public CameraCapturer(@NonNull Context context, @NonNull String cameraId, @Nullable Listener listener) {
        this(context, cameraId, listener, Util.createCallbackHandler());
    }

    @VisibleForTesting
    CameraCapturer(@NonNull Context context, @NonNull String cameraId, @Nullable Listener listener, @NonNull Handler handler) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(cameraId, "Camera source must not be null");
        Preconditions.checkArgument(!cameraId.isEmpty(), "Camera ID must not be empty");
        this.context = context;
        this.camera1Enumerator = new Camera1Enumerator(false);
        this.cameraId = cameraId;
        this.listener = listener;
        this.handler = handler;
    }

    public boolean isScreencast() {
        return false;
    }

    public void initialize(@NonNull SurfaceTextureHelper surfaceTextureHelper, @NonNull Context context, @NonNull CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
        this.webRtcCameraCapturer = (Camera1Capturer)this.camera1Enumerator.createCapturer(this.cameraId, this.cameraEventsHandler);
        this.webRtcCameraCapturer.initialize(surfaceTextureHelper, context, this.observerAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCapture(int width, int height, int framerate) {
        this.checkCapturerState();
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.IDLE || this.state == State.STOPPING) {
                logger.i("startCapture");
                this.state = State.STARTING;
                this.webRtcCameraCapturer.startCapture(width, height, framerate);
            } else if (this.state == State.STARTING || this.state == State.RUNNING) {
                logger.w("attempted to start capturing when capturer is starting or running");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCapture() {
        if (this.webRtcCameraCapturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STOPPING;
                this.cameraClosed = new CountDownLatch(1);
            }
            this.webRtcCameraCapturer.stopCapture();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)this.cameraClosed, (long)3000L)) {
                logger.e("Camera closed event not received");
            }
            object = this.stateLock;
            synchronized (object) {
                this.cameraClosed = null;
                this.state = State.IDLE;
            }
        }
    }

    @Override
    public void dispose() {
        if (this.webRtcCameraCapturer != null) {
            this.webRtcCameraCapturer.dispose();
            this.webRtcCameraCapturer = null;
        }
    }

    @NonNull
    public synchronized String getCameraId() {
        return this.cameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchCamera(@NonNull String newCameraId) {
        Preconditions.checkNotNull(newCameraId, "Camera ID must not be null");
        Preconditions.checkArgument(!newCameraId.isEmpty(), "Camera ID must not be empty");
        Preconditions.checkArgument(!newCameraId.equals(this.cameraId), "Camera ID must be different from current camera ID");
        Preconditions.checkArgument(CameraCapturer.cameraIdSupported(this.camera1Enumerator, newCameraId), "Camera ID %s is not supported or could not be validated", (Object)newCameraId);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                if (this.pendingCameraId == null) {
                    this.pendingCameraId = newCameraId;
                    this.webRtcCameraCapturer.switchCamera(this.cameraSwitchHandler, newCameraId);
                } else {
                    this.handler.post(() -> this.listener.onError(5));
                }
            } else {
                this.cameraId = newCameraId;
                this.listener.onCameraSwitched(this.cameraId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCameraParameters(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.parameterUpdatePending.get()) {
                    this.parameterUpdatePending.set(true);
                    return this.webRtcCameraCapturer.getHandler().post(() -> this.updateCameraParametersOnCameraThread(cameraParameterUpdater));
                }
                logger.w("Parameters will not be applied with parameter update pending");
                return false;
            }
            logger.i("Camera capturer is not running. Parameters will be applied when camera capturer is resumed");
            this.cameraParameterUpdater = cameraParameterUpdater;
            return true;
        }
    }

    private void checkCapturerState() {
        Preconditions.checkState(Util.permissionGranted(this.context, "android.permission.CAMERA"), "CAMERA permission must be granted to start capturer");
        Preconditions.checkState(CameraCapturer.cameraIdSupported(this.camera1Enumerator, this.cameraId), "Camera ID %s is not supported or could not be validated", (Object)this.cameraId);
    }

    private static boolean cameraIdSupported(@NonNull Camera1Enumerator camera1Enumerator, @NonNull String targetCameraId) {
        return Arrays.asList(camera1Enumerator.getDeviceNames()).contains(targetCameraId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCameraParametersOnCameraThread(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                Camera camera = this.camera1Session.getCamera();
                Camera.Parameters cameraParameters = camera.getParameters();
                logger.i("Applying camera parameters");
                cameraParameterUpdater.apply(cameraParameters);
                camera.stopPreview();
                camera.setPreviewCallbackWithBuffer(null);
                camera.setParameters(cameraParameters);
                Camera1Session.initializeCallbackBuffer((CameraEnumerationAndroid.CaptureFormat)this.camera1Session.getCaptureFormat(), (Camera)camera);
                this.camera1Session.listenForBytebufferFrames();
                camera.startPreview();
            } else {
                logger.w("Attempted to update camera parameters while camera capturer is not running");
            }
            this.parameterUpdatePending.set(false);
        }
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched(@NonNull String var1);

        public void onError(int var1);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

