/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.AccessedByNative;
import com.twilio.video.NetworkQualityVerbosity;
import com.twilio.video.Preconditions;

@AccessedByNative
public class NetworkQualityConfiguration {
    @AccessedByNative
    public final NetworkQualityVerbosity local;
    @AccessedByNative
    public final NetworkQualityVerbosity remote;

    public NetworkQualityConfiguration() {
        this(NetworkQualityVerbosity.NETWORK_QUALITY_VERBOSITY_MINIMAL, NetworkQualityVerbosity.NETWORK_QUALITY_VERBOSITY_NONE);
    }

    public NetworkQualityConfiguration(@NonNull NetworkQualityVerbosity local, @NonNull NetworkQualityVerbosity remote) {
        Preconditions.checkNotNull(local, "Local verbosity cannot be null");
        Preconditions.checkArgument(local != NetworkQualityVerbosity.NETWORK_QUALITY_VERBOSITY_NONE, "Local verbosity cannot be 'NetworkQualityVerbosity.NETWORK_QUALITY_VERBOSITY_NONE'");
        Preconditions.checkNotNull(remote, "Remote verbosity cannot be null");
        this.local = local;
        this.remote = remote;
    }

    @NonNull
    public String toString() {
        return "NetworkQualityConfiguration{local=" + (Object)((Object)this.local) + ", remote=" + (Object)((Object)this.remote) + '}';
    }
}

