/*
 * Copyright (C) 2017 Twilio, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.twilio.video;

import tvi.webrtc.Camera1Enumerator;

class CameraCapturerFormatProvider {
    private final Camera1Enumerator camera1Enumerator = new Camera1Enumerator(false);

    int getCameraId(CameraCapturer.CameraSource cameraSource) {
        int cameraId = -1;

        String[] deviceNames = camera1Enumerator.getDeviceNames();
        for (int i = 0; i < deviceNames.length; i++) {
            if ((camera1Enumerator.isFrontFacing(deviceNames[i])
                            && cameraSource == CameraCapturer.CameraSource.FRONT_CAMERA)
                    || (camera1Enumerator.isBackFacing(deviceNames[i])
                            && cameraSource == CameraCapturer.CameraSource.BACK_CAMERA)) {
                cameraId = i;
                break;
            }
        }

        return cameraId;
    }

    String getDeviceName(int cameraId) {
        String[] deviceNames = camera1Enumerator.getDeviceNames();

        if (cameraId < 0 || cameraId >= deviceNames.length) {
            throw new IllegalArgumentException("cameraId not available on this device");
        }

        return deviceNames[cameraId];
    }
}
