/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import android.graphics.Matrix;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoFrame;

class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, SurfaceTextureHelper surfaceTextureHelper, Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.releaseCallback = releaseCallback;
        this.refCount = 1;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.surfaceTextureHelper.textureToYuv(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        this.retain();
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.postScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        newMatrix.postTranslate((float)cropX / (float)this.width, (float)cropY / (float)this.height);
        return new TextureBufferImpl(scaleWidth, scaleHeight, this.type, this.id, newMatrix, this.surfaceTextureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }
}

