/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.ViewGroup;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.I420Frame;
import com.twilio.video.Logger;
import com.twilio.video.R;
import com.twilio.video.VideoRenderer;
import com.twilio.video.VideoScaleType;
import java.util.concurrent.CountDownLatch;
import tvi.webrtc.EglBase;
import tvi.webrtc.EglRenderer;
import tvi.webrtc.GlRectDrawer;
import tvi.webrtc.RendererCommon;
import tvi.webrtc.ThreadUtils;

public class VideoTextureView
extends TextureView
implements VideoRenderer,
TextureView.SurfaceTextureListener {
    private static final Logger logger = Logger.getLogger(VideoTextureView.class);
    private final RendererCommon.VideoLayoutMeasure videoLayoutMeasure = new RendererCommon.VideoLayoutMeasure();
    private final EglRenderer eglRenderer;
    private VideoScaleType videoScaleType = VideoScaleType.ASPECT_FIT;
    private RendererCommon.RendererEvents rendererEvents = new RendererCommon.RendererEvents(){

        public void onFirstFrameRendered() {
            if (VideoTextureView.this.listener != null) {
                VideoTextureView.this.listener.onFirstFrame();
            }
        }

        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
            if (VideoTextureView.this.listener != null) {
                VideoTextureView.this.listener.onFrameDimensionsChanged(videoWidth, videoHeight, rotation);
            }
        }
    };
    private VideoRenderer.Listener listener;
    private final Object layoutLock = new Object();
    private Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private boolean isFirstFrameRendered;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private int frameRotation;
    private boolean mirror;
    private int surfaceWidth;
    private int surfaceHeight;
    private EglBaseProvider eglBaseProvider;

    public VideoTextureView(@NonNull Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoTextureView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        String resourceName = this.getResourceName();
        this.eglRenderer = new EglRenderer(resourceName);
        this.setSurfaceTextureListener(this);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.VideoTextureView, 0, 0);
        try {
            this.mirror = a.getBoolean(R.styleable.VideoTextureView_tviMirror, false);
            this.videoScaleType = VideoScaleType.fromInt(a.getInteger(R.styleable.VideoTextureView_tviScaleType, 0));
        }
        finally {
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.eglBaseProvider = EglBaseProvider.instance(this);
            this.init(this.eglBaseProvider.getRootEglBase().getEglBaseContext(), this.rendererEvents);
        }
    }

    protected void onDetachedFromWindow() {
        this.eglRenderer.release();
        this.eglBaseProvider.release(this);
        super.onDetachedFromWindow();
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.eglRenderer.setMirror(mirror);
        this.mirror = mirror;
        this.requestLayout();
    }

    @NonNull
    public VideoScaleType getVideoScaleType() {
        return this.videoScaleType;
    }

    public void setVideoScaleType(@NonNull VideoScaleType scalingType) {
        ThreadUtils.checkIsOnMainThread();
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && (layoutParams.width == -1 || layoutParams.height == -1)) {
            VideoScaleType widthScaleType = layoutParams.width == -1 ? VideoScaleType.ASPECT_FILL : this.videoScaleType;
            VideoScaleType heightScaleType = layoutParams.height == -1 ? VideoScaleType.ASPECT_FILL : this.videoScaleType;
            logger.w(String.format("Scale type may not be applied as expected because video view uses MATCH_PARENT. Scaling will be applied as follows: width=%s, height=%s", widthScaleType.name(), heightScaleType.name()));
        }
        this.videoLayoutMeasure.setScalingType(this.convertToWebRtcScaleType(scalingType));
        this.videoScaleType = scalingType;
        this.requestLayout();
    }

    public void setListener(@Nullable VideoRenderer.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void renderFrame(@NonNull I420Frame frame) {
        this.updateFrameDimensionsAndReportEvents(frame);
        this.eglRenderer.renderFrame(frame.webRtcI420Frame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMeasure(int widthSpec, int heightSpec) {
        Point size;
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            size = this.videoLayoutMeasure.measure(widthSpec, heightSpec, this.rotatedFrameWidth, this.rotatedFrameHeight);
        }
        this.setMeasuredDimension(size.x, size.y);
        logger.v("onMeasure(). New size: " + size.x + "x" + size.y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
        this.updateSurfaceSize();
    }

    private void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents) {
        this.init(sharedContext, rendererEvents, EglBase.CONFIG_PLAIN, (RendererCommon.GlDrawer)new GlRectDrawer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(EglBase.Context sharedContext, RendererCommon.RendererEvents rendererEvents, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        this.rendererEvents = rendererEvents;
        Object object = this.layoutLock;
        synchronized (object) {
            this.rotatedFrameWidth = 0;
            this.rotatedFrameHeight = 0;
            this.frameRotation = 0;
        }
        this.eglRenderer.init(sharedContext, configAttributes, drawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.layoutLock;
        synchronized (object) {
            if (this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.getWidth() != 0 && this.getHeight() != 0) {
                int drawnFrameHeight;
                int drawnFrameWidth;
                float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
                float layoutAspectRatio = (float)this.getWidth() / (float)this.getHeight();
                if (frameAspectRatio > layoutAspectRatio) {
                    drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                    drawnFrameHeight = this.rotatedFrameHeight;
                } else {
                    drawnFrameWidth = this.rotatedFrameWidth;
                    drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
                }
                int width = Math.min(this.getWidth(), drawnFrameWidth);
                int height = Math.min(this.getHeight(), drawnFrameHeight);
                logger.v("updateSurfaceSize. Layout size: " + this.getWidth() + "x" + this.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
                if (width != this.surfaceWidth || height != this.surfaceHeight) {
                    this.surfaceWidth = width;
                    this.surfaceHeight = height;
                }
            } else {
                this.surfaceHeight = 0;
                this.surfaceWidth = 0;
            }
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        this.eglRenderer.createEglSurface(surfaceTexture);
        this.surfaceWidth = width;
        this.surfaceHeight = height;
        this.updateSurfaceSize();
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        CountDownLatch completionLatch = new CountDownLatch(1);
        this.eglRenderer.releaseEglSurface(completionLatch::countDown);
        ThreadUtils.awaitUninterruptibly((CountDownLatch)completionLatch);
        return true;
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int width, int height) {
        ThreadUtils.checkIsOnMainThread();
        logger.v("surfaceChanged: size: " + width + "x" + height);
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        ThreadUtils.checkIsOnMainThread();
        logger.v("onSurfaceTextureUpdated");
    }

    private String getResourceName() {
        try {
            return this.getResources().getResourceEntryName(this.getId()) + ": ";
        }
        catch (Resources.NotFoundException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFrameDimensionsAndReportEvents(I420Frame frame) {
        Object object = this.layoutLock;
        synchronized (object) {
            if (!this.isFirstFrameRendered) {
                this.isFirstFrameRendered = true;
                logger.v("Reporting first rendered frame.");
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFirstFrameRendered();
                }
            }
            if (this.rotatedFrameWidth != frame.rotatedWidth() || this.rotatedFrameHeight != frame.rotatedHeight() || this.frameRotation != frame.rotationDegree) {
                logger.v("Reporting frame resolution changed to " + frame.width + "x" + frame.height + " with rotation " + frame.rotationDegree);
                if (this.rendererEvents != null) {
                    this.rendererEvents.onFrameResolutionChanged(frame.width, frame.height, frame.rotationDegree);
                }
                this.rotatedFrameWidth = frame.rotatedWidth();
                this.rotatedFrameHeight = frame.rotatedHeight();
                this.frameRotation = frame.rotationDegree;
                this.uiThreadHandler.post(() -> {
                    this.updateSurfaceSize();
                    this.requestLayout();
                });
            }
        }
    }

    private RendererCommon.ScalingType convertToWebRtcScaleType(VideoScaleType videoScaleType) {
        switch (videoScaleType) {
            case ASPECT_FIT: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
            case ASPECT_FILL: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
            case ASPECT_BALANCED: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }
}

