/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import android.opengl.GLES20;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import tvi.webrtc.GlShader;
import tvi.webrtc.GlTextureFrameBuffer;
import tvi.webrtc.GlUtil;
import tvi.webrtc.JavaI420Buffer;
import tvi.webrtc.JniCommon;
import tvi.webrtc.RendererCommon;
import tvi.webrtc.ThreadUtils;
import tvi.webrtc.VideoFrame;

public class YuvConverter {
    private static final FloatBuffer DEVICE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private static final FloatBuffer TEXTURE_RECTANGLE = GlUtil.createFloatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private static final String VERTEX_SHADER = "varying vec2 interp_tc;\nattribute vec4 in_pos;\nattribute vec4 in_tc;\n\nuniform mat4 texMatrix;\n\nvoid main() {\n    gl_Position = in_pos;\n    interp_tc = (texMatrix * in_tc).xy;\n}\n";
    private static final String OES_FRAGMENT_SHADER = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 interp_tc;\n\nuniform samplerExternalOES tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private static final String RGB_FRAGMENT_SHADER = "precision mediump float;\nvarying vec2 interp_tc;\n\nuniform sampler2D tex;\nuniform vec2 xUnit;\nuniform vec4 coeffs;\n\nvoid main() {\n  gl_FragColor.r = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 1.5 * xUnit).rgb);\n  gl_FragColor.g = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc - 0.5 * xUnit).rgb);\n  gl_FragColor.b = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 0.5 * xUnit).rgb);\n  gl_FragColor.a = coeffs.a + dot(coeffs.rgb,\n      texture2D(tex, interp_tc + 1.5 * xUnit).rgb);\n}\n";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final GlTextureFrameBuffer textureFrameBuffer;
    private VideoFrame.TextureBuffer.Type shaderTextureType;
    private GlShader shader;
    private int texMatrixLoc;
    private int xUnitLoc;
    private int coeffsLoc;
    private boolean released = false;

    public YuvConverter() {
        this.threadChecker.checkIsOnValidThread();
        this.textureFrameBuffer = new GlTextureFrameBuffer(6408);
    }

    public VideoFrame.I420Buffer convert(VideoFrame.TextureBuffer textureBuffer) {
        int width = textureBuffer.getWidth();
        int height = textureBuffer.getHeight();
        int stride = (width + 7) / 8 * 8;
        int uvHeight = (height + 1) / 2;
        int size = stride * (height + uvHeight + 1);
        ByteBuffer buffer = JniCommon.nativeAllocateByteBuffer(size);
        this.convert(buffer, width, height, stride, textureBuffer.getTextureId(), RendererCommon.convertMatrixFromAndroidGraphicsMatrix(textureBuffer.getTransformMatrix()), textureBuffer.getType());
        boolean yPos = false;
        int uPos = 0 + stride * height;
        int vPos = uPos + stride / 2;
        buffer.position(0);
        buffer.limit(0 + stride * height);
        ByteBuffer dataY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(uPos + stride * uvHeight);
        ByteBuffer dataU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + stride * uvHeight);
        ByteBuffer dataV = buffer.slice();
        return JavaI420Buffer.wrap(width, height, dataY, stride, dataU, stride, dataV, stride, () -> JniCommon.nativeFreeByteBuffer(buffer));
    }

    @Deprecated
    public void convert(ByteBuffer buf, int width, int height, int stride, int srcTextureId, float[] transformMatrix) {
        this.convert(buf, width, height, stride, srcTextureId, transformMatrix, VideoFrame.TextureBuffer.Type.OES);
    }

    private void initShader(VideoFrame.TextureBuffer.Type textureType) {
        String fragmentShader;
        if (this.shader != null) {
            this.shader.release();
        }
        switch (textureType) {
            case OES: {
                fragmentShader = OES_FRAGMENT_SHADER;
                break;
            }
            case RGB: {
                fragmentShader = RGB_FRAGMENT_SHADER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported texture type.");
            }
        }
        this.shaderTextureType = textureType;
        this.shader = new GlShader(VERTEX_SHADER, fragmentShader);
        this.shader.useProgram();
        this.texMatrixLoc = this.shader.getUniformLocation("texMatrix");
        this.xUnitLoc = this.shader.getUniformLocation("xUnit");
        this.coeffsLoc = this.shader.getUniformLocation("coeffs");
        GLES20.glUniform1i((int)this.shader.getUniformLocation("tex"), (int)0);
        GlUtil.checkNoGLES2Error("Initialize fragment shader uniform values.");
        this.shader.setVertexAttribArray("in_pos", 2, DEVICE_RECTANGLE);
        this.shader.setVertexAttribArray("in_tc", 2, TEXTURE_RECTANGLE);
    }

    private void convert(ByteBuffer buf, int width, int height, int stride, int srcTextureId, float[] transformMatrix, VideoFrame.TextureBuffer.Type textureType) {
        this.threadChecker.checkIsOnValidThread();
        if (this.released) {
            throw new IllegalStateException("YuvConverter.convert called on released object");
        }
        if (textureType != this.shaderTextureType) {
            this.initShader(textureType);
        }
        this.shader.useProgram();
        if (stride % 8 != 0) {
            throw new IllegalArgumentException("Invalid stride, must be a multiple of 8");
        }
        if (stride < width) {
            throw new IllegalArgumentException("Invalid stride, must >= width");
        }
        int y_width = (width + 3) / 4;
        int uv_width = (width + 7) / 8;
        int uv_height = (height + 1) / 2;
        int total_height = height + uv_height;
        int size = stride * total_height;
        if (buf.capacity() < size) {
            throw new IllegalArgumentException("YuvConverter.convert called with too small buffer");
        }
        transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.verticalFlipMatrix());
        int frameBufferWidth = stride / 4;
        int frameBufferHeight = total_height;
        this.textureFrameBuffer.setSize(frameBufferWidth, frameBufferHeight);
        GLES20.glBindFramebuffer((int)36160, (int)this.textureFrameBuffer.getFrameBufferId());
        GlUtil.checkNoGLES2Error("glBindFramebuffer");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)textureType.getGlTarget(), (int)srcTextureId);
        GLES20.glUniformMatrix4fv((int)this.texMatrixLoc, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
        GLES20.glViewport((int)0, (int)0, (int)y_width, (int)height);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(transformMatrix[0] / (float)width), (float)(transformMatrix[1] / (float)width));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.299f, (float)0.587f, (float)0.114f, (float)0.0f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)0, (int)height, (int)uv_width, (int)uv_height);
        GLES20.glUniform2f((int)this.xUnitLoc, (float)(2.0f * transformMatrix[0] / (float)width), (float)(2.0f * transformMatrix[1] / (float)width));
        GLES20.glUniform4f((int)this.coeffsLoc, (float)-0.169f, (float)-0.331f, (float)0.499f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glViewport((int)(stride / 8), (int)height, (int)uv_width, (int)uv_height);
        GLES20.glUniform4f((int)this.coeffsLoc, (float)0.499f, (float)-0.418f, (float)-0.0813f, (float)0.5f);
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GLES20.glReadPixels((int)0, (int)0, (int)frameBufferWidth, (int)frameBufferHeight, (int)6408, (int)5121, (Buffer)buf);
        GlUtil.checkNoGLES2Error("YuvConverter.convert");
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindTexture((int)textureType.getGlTarget(), (int)0);
    }

    public void release() {
        this.threadChecker.checkIsOnValidThread();
        this.released = true;
        if (this.shader != null) {
            this.shader.release();
        }
        this.textureFrameBuffer.release();
    }
}

