/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tvi.webrtc.CalledByNative;
import tvi.webrtc.JNINamespace;
import tvi.webrtc.JniCommon;
import tvi.webrtc.MediaStreamTrack;
import tvi.webrtc.RtpReceiver;
import tvi.webrtc.RtpSender;

@JNINamespace(value="webrtc::jni")
public class RtpTransceiver {
    private final long nativeRtpTransceiver;
    private RtpSender cachedSender;
    private RtpReceiver cachedReceiver;

    @CalledByNative
    protected RtpTransceiver(long nativeRtpTransceiver) {
        this.nativeRtpTransceiver = nativeRtpTransceiver;
        this.cachedSender = RtpTransceiver.nativeGetSender(nativeRtpTransceiver);
        this.cachedReceiver = RtpTransceiver.nativeGetReceiver(nativeRtpTransceiver);
    }

    public MediaStreamTrack.MediaType getMediaType() {
        return RtpTransceiver.nativeGetMediaType(this.nativeRtpTransceiver);
    }

    public String getMid() {
        return RtpTransceiver.nativeGetMid(this.nativeRtpTransceiver);
    }

    public RtpSender getSender() {
        return this.cachedSender;
    }

    public RtpReceiver getReceiver() {
        return this.cachedReceiver;
    }

    public boolean isStopped() {
        return RtpTransceiver.nativeStopped(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getDirection() {
        return RtpTransceiver.nativeDirection(this.nativeRtpTransceiver);
    }

    public RtpTransceiverDirection getCurrentDirection() {
        return RtpTransceiver.nativeCurrentDirection(this.nativeRtpTransceiver);
    }

    public void setDirection(RtpTransceiverDirection rtpTransceiverDirection) {
        RtpTransceiver.nativeSetDirection(this.nativeRtpTransceiver, rtpTransceiverDirection);
    }

    public void stop() {
        RtpTransceiver.nativeStop(this.nativeRtpTransceiver);
    }

    public void dispose() {
        this.cachedSender.dispose();
        this.cachedReceiver.dispose();
        JniCommon.nativeReleaseRef(this.nativeRtpTransceiver);
    }

    private static native MediaStreamTrack.MediaType nativeGetMediaType(long var0);

    private static native String nativeGetMid(long var0);

    private static native RtpSender nativeGetSender(long var0);

    private static native RtpReceiver nativeGetReceiver(long var0);

    private static native boolean nativeStopped(long var0);

    private static native RtpTransceiverDirection nativeDirection(long var0);

    private static native RtpTransceiverDirection nativeCurrentDirection(long var0);

    private static native void nativeStop(long var0);

    private static native void nativeSetDirection(long var0, RtpTransceiverDirection var2);

    public static final class RtpTransceiverInit {
        private final RtpTransceiverDirection direction;
        private final List<String> streamIds;

        public RtpTransceiverInit() {
            this(RtpTransceiverDirection.SEND_RECV);
        }

        public RtpTransceiverInit(RtpTransceiverDirection direction) {
            this(direction, Collections.emptyList());
        }

        public RtpTransceiverInit(RtpTransceiverDirection direction, List<String> streamIds) {
            this.direction = direction;
            this.streamIds = new ArrayList<String>(streamIds);
        }

        @CalledByNative(value="RtpTransceiverInit")
        int getDirectionNativeIndex() {
            return this.direction.getNativeIndex();
        }

        @CalledByNative(value="RtpTransceiverInit")
        List<String> getStreamIds() {
            return new ArrayList<String>(this.streamIds);
        }
    }

    public static enum RtpTransceiverDirection {
        SEND_RECV(0),
        SEND_ONLY(1),
        RECV_ONLY(2),
        INACTIVE(3);

        private final int nativeIndex;

        private RtpTransceiverDirection(int nativeIndex) {
            this.nativeIndex = nativeIndex;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        int getNativeIndex() {
            return this.nativeIndex;
        }

        @CalledByNative(value="RtpTransceiverDirection")
        static RtpTransceiverDirection fromNativeIndex(int nativeIndex) {
            for (RtpTransceiverDirection type : RtpTransceiverDirection.values()) {
                if (type.getNativeIndex() != nativeIndex) continue;
                return type;
            }
            throw new IllegalArgumentException("Uknown native RtpTransceiverDirection type" + nativeIndex);
        }
    }
}

