/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import com.twilio.video.AudioSink;
import com.twilio.video.AudioSinkProxy;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import java.util.HashMap;

public abstract class AudioTrack
implements Track {
    private static final Logger logger = Logger.getLogger(AudioTrack.class);
    private long nativeAudioTrackHandle;
    private final String name;
    private boolean isEnabled;
    protected final HashMap<AudioSink, AudioSinkProxy> audioSinks;

    AudioTrack(long nativeAudioTrackHandle, boolean isEnabled, @NonNull String name) {
        this.nativeAudioTrackHandle = nativeAudioTrackHandle;
        this.isEnabled = isEnabled;
        this.name = name;
        this.audioSinks = new HashMap();
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    public synchronized void addSink(@NonNull AudioSink audioSink) {
        Preconditions.checkNotNull(audioSink);
        if (!this.isReleased()) {
            if (!this.audioSinks.containsKey(audioSink)) {
                AudioSinkProxy proxy = new AudioSinkProxy(audioSink);
                this.audioSinks.put(audioSink, proxy);
                this.nativeAddSink(this.nativeAudioTrackHandle, proxy);
            }
        } else {
            logger.w("Cannot add sink to released audio track");
        }
    }

    public synchronized void removeSink(@NonNull AudioSink audioSink) {
        Preconditions.checkNotNull(audioSink);
        if (!this.isReleased()) {
            AudioSinkProxy proxy = this.audioSinks.get(audioSink);
            if (proxy != null) {
                this.nativeRemoveSink(this.nativeAudioTrackHandle, proxy);
                this.audioSinks.remove(audioSink);
                proxy.release();
            }
        } else {
            logger.w("Cannot remove sink from released audio track");
        }
    }

    void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    abstract void release();

    abstract boolean isReleased();

    private native void nativeAddSink(long var1, AudioSink var3);

    private native void nativeRemoveSink(long var1, AudioSink var3);
}

