/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import android.content.Context;
import java.util.List;
import javax.annotation.Nullable;
import tvi.webrtc.AndroidVideoTrackSourceObserver;
import tvi.webrtc.AudioProcessingFactory;
import tvi.webrtc.AudioSource;
import tvi.webrtc.AudioTrack;
import tvi.webrtc.CalledByNative;
import tvi.webrtc.ContextUtils;
import tvi.webrtc.EglBase;
import tvi.webrtc.FecControllerFactoryFactoryInterface;
import tvi.webrtc.JNINamespace;
import tvi.webrtc.Logging;
import tvi.webrtc.MediaConstraints;
import tvi.webrtc.MediaStream;
import tvi.webrtc.NativeLibrary;
import tvi.webrtc.NativeLibraryLoader;
import tvi.webrtc.PeerConnection;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.VideoCapturer;
import tvi.webrtc.VideoDecoderFactory;
import tvi.webrtc.VideoEncoderFactory;
import tvi.webrtc.VideoSource;
import tvi.webrtc.VideoTrack;
import tvi.webrtc.audio.AudioDeviceModule;
import tvi.webrtc.audio.LegacyAudioDeviceModule;

@JNINamespace(value="webrtc::jni")
public class PeerConnectionFactory {
    public static final String TRIAL_ENABLED = "Enabled";
    @Deprecated
    public static final String VIDEO_FRAME_EMIT_TRIAL = "VideoFrameEmit";
    private static final String TAG = "PeerConnectionFactory";
    private static final String VIDEO_CAPTURER_THREAD_NAME = "VideoCapturerThread";
    private final long nativeFactory;
    private static volatile boolean internalTracerInitialized = false;
    @Nullable
    private static Thread networkThread;
    @Nullable
    private static Thread workerThread;
    @Nullable
    private static Thread signalingThread;
    private EglBase localEglbase;
    private EglBase remoteEglbase;

    public static Builder builder() {
        return new Builder();
    }

    public static void initialize(InitializationOptions options) {
        ContextUtils.initialize(options.applicationContext);
        NativeLibrary.initialize(options.nativeLibraryLoader);
        PeerConnectionFactory.nativeInitializeAndroidGlobals(options.enableVideoHwAcceleration);
        PeerConnectionFactory.initializeFieldTrials(options.fieldTrials);
        if (options.enableInternalTracer && !internalTracerInitialized) {
            PeerConnectionFactory.initializeInternalTracer();
        }
    }

    private void checkInitializeHasBeenCalled() {
        if (!NativeLibrary.isLoaded() || ContextUtils.getApplicationContext() == null) {
            throw new IllegalStateException("PeerConnectionFactory.initialize was not called before creating a PeerConnectionFactory.");
        }
    }

    private static void initializeInternalTracer() {
        internalTracerInitialized = true;
        PeerConnectionFactory.nativeInitializeInternalTracer();
    }

    public static void shutdownInternalTracer() {
        internalTracerInitialized = false;
        PeerConnectionFactory.nativeShutdownInternalTracer();
    }

    @Deprecated
    public static void initializeFieldTrials(String fieldTrialsInitString) {
        PeerConnectionFactory.nativeInitializeFieldTrials(fieldTrialsInitString);
    }

    public static String fieldTrialsFindFullName(String name) {
        return NativeLibrary.isLoaded() ? PeerConnectionFactory.nativeFindFieldTrialsFullName(name) : "";
    }

    public static boolean startInternalTracingCapture(String tracingFilename) {
        return PeerConnectionFactory.nativeStartInternalTracingCapture(tracingFilename);
    }

    public static void stopInternalTracingCapture() {
        PeerConnectionFactory.nativeStopInternalTracingCapture();
    }

    @Deprecated
    public PeerConnectionFactory() {
        this(null);
    }

    @Deprecated
    public PeerConnectionFactory(Options options) {
        this(options, null, null);
    }

    @Deprecated
    public PeerConnectionFactory(Options options, VideoEncoderFactory encoderFactory, VideoDecoderFactory decoderFactory) {
        this.checkInitializeHasBeenCalled();
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(ContextUtils.getApplicationContext(), options, 0L, encoderFactory, decoderFactory, 0L, 0L);
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    @Deprecated
    public PeerConnectionFactory(Options options, VideoEncoderFactory encoderFactory, VideoDecoderFactory decoderFactory, AudioProcessingFactory audioProcessingFactory) {
        this(options, new LegacyAudioDeviceModule(), encoderFactory, decoderFactory, audioProcessingFactory, null);
    }

    private PeerConnectionFactory(Options options, @Nullable AudioDeviceModule audioDeviceModule, @Nullable VideoEncoderFactory encoderFactory, @Nullable VideoDecoderFactory decoderFactory, @Nullable AudioProcessingFactory audioProcessingFactory, @Nullable FecControllerFactoryFactoryInterface fecControllerFactoryFactory) {
        this.checkInitializeHasBeenCalled();
        this.nativeFactory = PeerConnectionFactory.nativeCreatePeerConnectionFactory(ContextUtils.getApplicationContext(), options, audioDeviceModule == null ? 0L : audioDeviceModule.getNativeAudioDeviceModulePointer(), encoderFactory, decoderFactory, audioProcessingFactory == null ? 0L : audioProcessingFactory.createNative(), fecControllerFactoryFactory == null ? 0L : fecControllerFactoryFactory.createNative());
        if (this.nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
    }

    @CalledByNative
    PeerConnectionFactory(long nativeFactory) {
        this.checkInitializeHasBeenCalled();
        if (nativeFactory == 0L) {
            throw new RuntimeException("Failed to initialize PeerConnectionFactory!");
        }
        this.nativeFactory = nativeFactory;
    }

    @Nullable
    @Deprecated
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, MediaConstraints constraints, PeerConnection.Observer observer) {
        long nativeObserver = PeerConnection.createNativePeerConnectionObserver(observer);
        if (nativeObserver == 0L) {
            return null;
        }
        long nativePeerConnection = PeerConnectionFactory.nativeCreatePeerConnection(this.nativeFactory, rtcConfig, constraints, nativeObserver);
        if (nativePeerConnection == 0L) {
            return null;
        }
        return new PeerConnection(nativePeerConnection);
    }

    @Nullable
    @Deprecated
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, MediaConstraints constraints, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        return this.createPeerConnection(rtcConfig, constraints, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(List<PeerConnection.IceServer> iceServers, PeerConnection.Observer observer) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        return this.createPeerConnection(rtcConfig, observer);
    }

    @Nullable
    public PeerConnection createPeerConnection(PeerConnection.RTCConfiguration rtcConfig, PeerConnection.Observer observer) {
        return this.createPeerConnection(rtcConfig, null, observer);
    }

    public MediaStream createLocalMediaStream(String label) {
        return new MediaStream(PeerConnectionFactory.nativeCreateLocalMediaStream(this.nativeFactory, label));
    }

    public VideoSource createVideoSource(VideoCapturer capturer) {
        EglBase.Context eglContext = this.localEglbase == null ? null : this.localEglbase.getEglBaseContext();
        SurfaceTextureHelper surfaceTextureHelper = SurfaceTextureHelper.create(VIDEO_CAPTURER_THREAD_NAME, eglContext);
        long nativeAndroidVideoTrackSource = PeerConnectionFactory.nativeCreateVideoSource(this.nativeFactory, surfaceTextureHelper, capturer.isScreencast());
        AndroidVideoTrackSourceObserver capturerObserver = new AndroidVideoTrackSourceObserver(nativeAndroidVideoTrackSource);
        capturer.initialize(surfaceTextureHelper, ContextUtils.getApplicationContext(), capturerObserver);
        return new VideoSource(nativeAndroidVideoTrackSource);
    }

    public VideoTrack createVideoTrack(String id, VideoSource source) {
        return new VideoTrack(PeerConnectionFactory.nativeCreateVideoTrack(this.nativeFactory, id, source.nativeSource));
    }

    public AudioSource createAudioSource(MediaConstraints constraints) {
        return new AudioSource(PeerConnectionFactory.nativeCreateAudioSource(this.nativeFactory, constraints));
    }

    public AudioTrack createAudioTrack(String id, AudioSource source) {
        return new AudioTrack(PeerConnectionFactory.nativeCreateAudioTrack(this.nativeFactory, id, source.nativeSource));
    }

    public boolean startAecDump(int file_descriptor, int filesize_limit_bytes) {
        return PeerConnectionFactory.nativeStartAecDump(this.nativeFactory, file_descriptor, filesize_limit_bytes);
    }

    public void stopAecDump() {
        PeerConnectionFactory.nativeStopAecDump(this.nativeFactory);
    }

    @Deprecated
    public void setOptions(Options options) {
        this.nativeSetOptions(this.nativeFactory, options);
    }

    public void setVideoHwAccelerationOptions(EglBase.Context localEglContext, EglBase.Context remoteEglContext) {
        if (this.localEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            Logging.w(TAG, "Egl context already set.");
            this.remoteEglbase.release();
        }
        this.localEglbase = EglBase.create(localEglContext);
        this.remoteEglbase = EglBase.create(remoteEglContext);
        PeerConnectionFactory.nativeSetVideoHwAccelerationOptions(this.nativeFactory, this.localEglbase.getEglBaseContext(), this.remoteEglbase.getEglBaseContext());
    }

    public void dispose() {
        PeerConnectionFactory.nativeFreeFactory(this.nativeFactory);
        networkThread = null;
        workerThread = null;
        signalingThread = null;
        if (this.localEglbase != null) {
            this.localEglbase.release();
        }
        if (this.remoteEglbase != null) {
            this.remoteEglbase.release();
        }
    }

    public void threadsCallbacks() {
        PeerConnectionFactory.nativeInvokeThreadsCallbacks(this.nativeFactory);
    }

    public long getNativePeerConnectionFactory() {
        return PeerConnectionFactory.nativeGetNativePeerConnectionFactory(this.nativeFactory);
    }

    public long getNativeOwnedFactoryAndThreads() {
        return this.nativeFactory;
    }

    private static void printStackTrace(@Nullable Thread thread, String threadName) {
        StackTraceElement[] stackTraces;
        if (thread != null && (stackTraces = thread.getStackTrace()).length > 0) {
            Logging.d(TAG, threadName + " stacks trace:");
            for (StackTraceElement stackTrace : stackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    public static void printStackTraces() {
        PeerConnectionFactory.printStackTrace(networkThread, "Network thread");
        PeerConnectionFactory.printStackTrace(workerThread, "Worker thread");
        PeerConnectionFactory.printStackTrace(signalingThread, "Signaling thread");
    }

    @CalledByNative
    private static void onNetworkThreadReady() {
        networkThread = Thread.currentThread();
        Logging.d(TAG, "onNetworkThreadReady");
    }

    @CalledByNative
    private static void onWorkerThreadReady() {
        workerThread = Thread.currentThread();
        Logging.d(TAG, "onWorkerThreadReady");
    }

    @CalledByNative
    private static void onSignalingThreadReady() {
        signalingThread = Thread.currentThread();
        Logging.d(TAG, "onSignalingThreadReady");
    }

    private static native void nativeInitializeAndroidGlobals(boolean var0);

    private static native void nativeInitializeFieldTrials(String var0);

    private static native String nativeFindFieldTrialsFullName(String var0);

    private static native void nativeInitializeInternalTracer();

    private static native void nativeShutdownInternalTracer();

    private static native boolean nativeStartInternalTracingCapture(String var0);

    private static native void nativeStopInternalTracingCapture();

    private static native long nativeCreatePeerConnectionFactory(Context var0, Options var1, long var2, VideoEncoderFactory var4, VideoDecoderFactory var5, long var6, long var8);

    private static native long nativeCreatePeerConnection(long var0, PeerConnection.RTCConfiguration var2, MediaConstraints var3, long var4);

    private static native long nativeCreateLocalMediaStream(long var0, String var2);

    private static native long nativeCreateVideoSource(long var0, SurfaceTextureHelper var2, boolean var3);

    private static native long nativeCreateVideoTrack(long var0, String var2, long var3);

    private static native long nativeCreateAudioSource(long var0, MediaConstraints var2);

    private static native long nativeCreateAudioTrack(long var0, String var2, long var3);

    private static native boolean nativeStartAecDump(long var0, int var2, int var3);

    private static native void nativeStopAecDump(long var0);

    @Deprecated
    public native void nativeSetOptions(long var1, Options var3);

    private static native void nativeSetVideoHwAccelerationOptions(long var0, Object var2, Object var3);

    private static native void nativeInvokeThreadsCallbacks(long var0);

    private static native void nativeFreeFactory(long var0);

    private static native long nativeGetNativePeerConnectionFactory(long var0);

    public static class Builder {
        @Nullable
        private Options options;
        @Nullable
        private AudioDeviceModule audioDeviceModule = new LegacyAudioDeviceModule();
        @Nullable
        private VideoEncoderFactory encoderFactory;
        @Nullable
        private VideoDecoderFactory decoderFactory;
        @Nullable
        private AudioProcessingFactory audioProcessingFactory;
        @Nullable
        private FecControllerFactoryFactoryInterface fecControllerFactoryFactory;

        private Builder() {
        }

        public Builder setOptions(Options options) {
            this.options = options;
            return this;
        }

        public Builder setAudioDeviceModule(AudioDeviceModule audioDeviceModule) {
            this.audioDeviceModule = audioDeviceModule;
            return this;
        }

        public Builder setVideoEncoderFactory(VideoEncoderFactory encoderFactory) {
            this.encoderFactory = encoderFactory;
            return this;
        }

        public Builder setVideoDecoderFactory(VideoDecoderFactory decoderFactory) {
            this.decoderFactory = decoderFactory;
            return this;
        }

        public Builder setAudioProcessingFactory(AudioProcessingFactory audioProcessingFactory) {
            if (audioProcessingFactory == null) {
                throw new NullPointerException("PeerConnectionFactory builder does not accept a null AudioProcessingFactory.");
            }
            this.audioProcessingFactory = audioProcessingFactory;
            return this;
        }

        public Builder setFecControllerFactoryFactoryInterface(FecControllerFactoryFactoryInterface fecControllerFactoryFactory) {
            this.fecControllerFactoryFactory = fecControllerFactoryFactory;
            return this;
        }

        public PeerConnectionFactory createPeerConnectionFactory() {
            return new PeerConnectionFactory(this.options, this.audioDeviceModule, this.encoderFactory, this.decoderFactory, this.audioProcessingFactory, this.fecControllerFactoryFactory);
        }
    }

    public static class Options {
        static final int ADAPTER_TYPE_UNKNOWN = 0;
        static final int ADAPTER_TYPE_ETHERNET = 1;
        static final int ADAPTER_TYPE_WIFI = 2;
        static final int ADAPTER_TYPE_CELLULAR = 4;
        static final int ADAPTER_TYPE_VPN = 8;
        static final int ADAPTER_TYPE_LOOPBACK = 16;
        public int networkIgnoreMask;
        public boolean disableEncryption;
        public boolean disableNetworkMonitor;
        public boolean enableAes128Sha1_32CryptoCipher;

        @CalledByNative(value="Options")
        int getNetworkIgnoreMask() {
            return this.networkIgnoreMask;
        }

        @CalledByNative(value="Options")
        boolean getDisableEncryption() {
            return this.disableEncryption;
        }

        @CalledByNative(value="Options")
        boolean getDisableNetworkMonitor() {
            return this.disableNetworkMonitor;
        }

        @CalledByNative(value="Options")
        boolean getEnableAes128Sha1_32CryptoCipher() {
            return this.enableAes128Sha1_32CryptoCipher;
        }
    }

    public static class InitializationOptions {
        final Context applicationContext;
        final String fieldTrials;
        final boolean enableInternalTracer;
        final boolean enableVideoHwAcceleration;
        final NativeLibraryLoader nativeLibraryLoader;

        private InitializationOptions(Context applicationContext, String fieldTrials, boolean enableInternalTracer, boolean enableVideoHwAcceleration, NativeLibraryLoader nativeLibraryLoader) {
            this.applicationContext = applicationContext;
            this.fieldTrials = fieldTrials;
            this.enableInternalTracer = enableInternalTracer;
            this.enableVideoHwAcceleration = enableVideoHwAcceleration;
            this.nativeLibraryLoader = nativeLibraryLoader;
        }

        public static Builder builder(Context applicationContext) {
            return new Builder(applicationContext);
        }

        public static class Builder {
            private final Context applicationContext;
            private String fieldTrials = "";
            private boolean enableInternalTracer = false;
            private boolean enableVideoHwAcceleration = true;
            private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();

            Builder(Context applicationContext) {
                this.applicationContext = applicationContext;
            }

            public Builder setFieldTrials(String fieldTrials) {
                this.fieldTrials = fieldTrials;
                return this;
            }

            public Builder setEnableInternalTracer(boolean enableInternalTracer) {
                this.enableInternalTracer = enableInternalTracer;
                return this;
            }

            public Builder setEnableVideoHwAcceleration(boolean enableVideoHwAcceleration) {
                this.enableVideoHwAcceleration = enableVideoHwAcceleration;
                return this;
            }

            public Builder setNativeLibraryLoader(NativeLibraryLoader nativeLibraryLoader) {
                this.nativeLibraryLoader = nativeLibraryLoader;
                return this;
            }

            public InitializationOptions createInitializationOptions() {
                return new InitializationOptions(this.applicationContext, this.fieldTrials, this.enableInternalTracer, this.enableVideoHwAcceleration, this.nativeLibraryLoader);
            }
        }
    }
}

