/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageDecoder;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.CameraCapturerFormatProvider;
import com.twilio.video.CameraParameterUpdater;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import com.twilio.video.VideoPixelFormat;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import tvi.webrtc.Camera1Capturer;
import tvi.webrtc.Camera1Session;
import tvi.webrtc.CameraVideoCapturer;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.ThreadUtils;
import tvi.webrtc.VideoCapturer;
import tvi.webrtc.VideoFrame;

public class CameraCapturer
implements VideoCapturer {
    private static final int CAMERA_CLOSED_TIMEOUT_MS = 3000;
    private static final String CAMERA_CLOSED_FAILED = "Failed to close camera";
    private static final String ERROR_MESSAGE_CAMERA_SERVER_DIED = "Camera server died!";
    private static final String ERROR_MESSAGE_UNKNOWN = "Camera error:";
    private static final Logger logger = Logger.getLogger(CameraCapturer.class);
    public static final int ERROR_CAMERA_FREEZE = 0;
    public static final int ERROR_CAMERA_SERVER_STOPPED = 1;
    public static final int ERROR_UNSUPPORTED_SOURCE = 2;
    public static final int ERROR_CAMERA_PERMISSION_NOT_GRANTED = 3;
    public static final int ERROR_CAMERA_SWITCH_FAILED = 5;
    public static final int ERROR_UNKNOWN = 6;
    private final Object stateLock = new Object();
    private State state = State.IDLE;
    private final Context context;
    private final CameraCapturerFormatProvider formatProvider;
    private final AtomicBoolean picturePending = new AtomicBoolean(false);
    private final AtomicBoolean parameterUpdatePending = new AtomicBoolean(false);
    private Listener listener;
    private Camera1Capturer webRtcCameraCapturer;
    private CameraSource cameraSource;
    private Camera1Session camera1Session;
    private VideoCapturer.Listener videoCapturerListener;
    private SurfaceTextureHelper surfaceTextureHelper;
    private final VideoCapturer.CapturerObserver observerAdapter = new VideoCapturer.CapturerObserver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapturerStarted(boolean success) {
            CameraCapturer.this.videoCapturerListener.onCapturerStarted(success);
            CameraCapturer.this.camera1Session = CameraCapturer.this.webRtcCameraCapturer.getCameraSession();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.state == State.STARTING) {
                    CameraCapturer.this.state = State.RUNNING;
                    if (CameraCapturer.this.cameraParameterUpdater != null) {
                        CameraCapturer.this.updateCameraParametersOnCameraThread(CameraCapturer.this.cameraParameterUpdater);
                        CameraCapturer.this.cameraParameterUpdater = null;
                    }
                    if (CameraCapturer.this.pictureListener != null) {
                        CameraCapturer.this.takePicture(CameraCapturer.this.pictureListener);
                        CameraCapturer.this.pictureListener = null;
                    }
                } else {
                    logger.w("Attempted to transition from " + (Object)((Object)CameraCapturer.this.state) + " to RUNNING");
                }
            }
        }

        public void onCapturerStopped() {
        }

        public void onFrameCaptured(tvi.webrtc.VideoFrame videoFrame) {
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            VideoDimensions dimensions = new VideoDimensions(buffer.getWidth(), buffer.getHeight());
            VideoFrame.RotationAngle orientation = VideoFrame.RotationAngle.fromInt(videoFrame.getRotation());
            CameraCapturer.this.videoCapturerListener.onFrameCaptured(new VideoFrame(videoFrame, dimensions, orientation));
        }
    };
    private CameraParameterUpdater cameraParameterUpdater;
    private PictureListener pictureListener;
    private CountDownLatch cameraClosed;
    private final CameraVideoCapturer.CameraEventsHandler cameraEventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraError(String errorMsg) {
            if (CameraCapturer.this.listener != null) {
                if (errorMsg.equals(CameraCapturer.ERROR_MESSAGE_CAMERA_SERVER_DIED)) {
                    logger.e("Camera server stopped.");
                    CameraCapturer.this.listener.onError(1);
                } else if (errorMsg.contains(CameraCapturer.ERROR_MESSAGE_UNKNOWN)) {
                    logger.e("Unknown camera error occurred.");
                    CameraCapturer.this.listener.onError(6);
                }
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraFreezed(String s) {
            logger.e("Camera froze.");
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(0);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }

        public void onCameraOpening(String message) {
        }

        public void onFirstFrameAvailable() {
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onFirstFrameAvailable();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraClosed() {
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.state == State.STOPPING) {
                    CameraCapturer.this.camera1Session = null;
                    CameraCapturer.this.cameraClosed.countDown();
                }
            }
        }

        public void onCameraDisconnected() {
        }
    };
    private final CameraVideoCapturer.CameraSwitchHandler cameraSwitchHandler = new CameraVideoCapturer.CameraSwitchHandler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchDone(boolean isFrontCamera) {
            CameraCapturer cameraCapturer = CameraCapturer.this;
            synchronized (cameraCapturer) {
                CameraCapturer.this.cameraSource = CameraCapturer.this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
            }
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onCameraSwitched();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraSwitchError(String errorMessage) {
            logger.e("Failed to switch to camera source " + (Object)((Object)CameraCapturer.this.cameraSource));
            if (CameraCapturer.this.listener != null) {
                CameraCapturer.this.listener.onError(5);
            }
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.state = State.IDLE;
            }
        }
    };

    public static boolean isSourceAvailable(@NonNull CameraSource cameraSource) {
        Preconditions.checkNotNull(cameraSource, "Camera source must not be null");
        CameraCapturerFormatProvider cameraCapturerFormatProvider = new CameraCapturerFormatProvider();
        return CameraCapturer.isSourceAvailable(cameraCapturerFormatProvider, cameraSource);
    }

    static boolean isSourceAvailable(@NonNull CameraCapturerFormatProvider cameraCapturerFormatProvider, @NonNull CameraSource cameraSource) {
        return cameraCapturerFormatProvider.getCameraId(cameraSource) != -1;
    }

    public CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource) {
        this(context, cameraSource, null);
    }

    public CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource, @Nullable Listener listener) {
        this(context, cameraSource, listener, new CameraCapturerFormatProvider());
    }

    @VisibleForTesting(otherwise=2)
    CameraCapturer(@NonNull Context context, @NonNull CameraSource cameraSource, @Nullable Listener listener, @NonNull CameraCapturerFormatProvider formatProvider) {
        Preconditions.checkNotNull(context, "Context must not be null");
        Preconditions.checkNotNull(cameraSource, "Camera source must not be null");
        this.context = context;
        this.cameraSource = cameraSource;
        this.listener = listener;
        this.formatProvider = formatProvider;
    }

    @Override
    @NonNull
    public synchronized List<VideoFormat> getSupportedFormats() {
        Preconditions.checkState(Util.permissionGranted(this.context, "android.permission.CAMERA"), "CAMERA permission must be granted to create videotrack with CameraCapturer");
        List<VideoFormat> supportedFormats = this.formatProvider.getSupportedFormats(this.cameraSource);
        Preconditions.checkState(!supportedFormats.isEmpty(), "Supported formats could not be retrieved because an error occurred connecting to the camera service");
        return supportedFormats;
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(@NonNull VideoFormat captureFormat, @NonNull VideoCapturer.Listener videoCapturerListener) {
        boolean capturerCreated = this.createWebRtcCameraCapturer();
        if (capturerCreated) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STARTING;
            }
            this.videoCapturerListener = videoCapturerListener;
            this.webRtcCameraCapturer.initialize(this.surfaceTextureHelper, this.context, this.observerAdapter);
            this.webRtcCameraCapturer.startCapture(captureFormat.dimensions.width, captureFormat.dimensions.height, captureFormat.framerate);
        } else {
            logger.e("Failed to startCapture");
            videoCapturerListener.onCapturerStarted(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        if (this.webRtcCameraCapturer != null) {
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.STOPPING;
                this.cameraClosed = new CountDownLatch(1);
            }
            this.webRtcCameraCapturer.stopCapture();
            this.webRtcCameraCapturer.dispose();
            this.webRtcCameraCapturer = null;
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)this.cameraClosed, (long)3000L)) {
                logger.e("Camera closed event not received");
            }
            object = this.stateLock;
            synchronized (object) {
                this.cameraClosed = null;
                this.state = State.IDLE;
            }
        }
    }

    @NonNull
    public synchronized CameraSource getCameraSource() {
        return this.cameraSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void switchCamera() {
        CameraSource nextCameraSource = this.cameraSource == CameraSource.FRONT_CAMERA ? CameraSource.BACK_CAMERA : CameraSource.FRONT_CAMERA;
        boolean nextCameraSourceSupported = CameraCapturer.isSourceAvailable(this.formatProvider, nextCameraSource);
        if (!nextCameraSourceSupported) {
            logger.w(String.format("Cannot switch to unsupported camera source %s", new Object[]{nextCameraSource}));
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != State.IDLE) {
                this.webRtcCameraCapturer.switchCamera(this.cameraSwitchHandler);
            } else {
                this.cameraSource = nextCameraSource;
                if (this.listener != null) {
                    this.listener.onCameraSwitched();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean updateCameraParameters(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.parameterUpdatePending.get()) {
                    this.parameterUpdatePending.set(true);
                    return this.camera1Session.cameraThreadHandler.post(() -> this.updateCameraParametersOnCameraThread(cameraParameterUpdater));
                }
                logger.w("Parameters will not be applied with parameter update pending");
                return false;
            }
            logger.i("Camera capturer is not running. Parameters will be applied when camera capturer is resumed");
            this.cameraParameterUpdater = cameraParameterUpdater;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean takePicture(@NonNull PictureListener pictureListener) {
        Preconditions.checkNotNull(pictureListener);
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                if (!this.picturePending.get()) {
                    this.picturePending.set(true);
                    Handler pictureListenerHandler = Util.createCallbackHandler();
                    return this.camera1Session.cameraThreadHandler.post(() -> this.takePictureOnCameraThread(pictureListenerHandler, pictureListener));
                }
                logger.w("Picture cannot be taken while picture is pending");
                return false;
            }
            logger.i("Camera capturer is not running. Picture request will be serviced when camera capturer is resumed");
            this.pictureListener = pictureListener;
            return true;
        }
    }

    void setSurfaceTextureHelper(@NonNull SurfaceTextureHelper surfaceTextureHelper) {
        this.surfaceTextureHelper = surfaceTextureHelper;
    }

    @NonNull
    private List<VideoFormat> defaultFormats() {
        ArrayList<VideoFormat> defaultFormats = new ArrayList<VideoFormat>();
        VideoDimensions defaultDimensions = new VideoDimensions(640, 480);
        VideoFormat defaultFormat = new VideoFormat(defaultDimensions, 30, VideoPixelFormat.NV21);
        defaultFormats.add(defaultFormat);
        return defaultFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createWebRtcCameraCapturer() {
        if (!Util.permissionGranted(this.context, "android.permission.CAMERA")) {
            logger.e("CAMERA permission must be granted to start capturer");
            if (this.listener != null) {
                this.listener.onError(3);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.IDLE;
            }
            return false;
        }
        int cameraId = this.formatProvider.getCameraId(this.cameraSource);
        String deviceName = this.formatProvider.getDeviceName(cameraId);
        if (cameraId < 0 || deviceName == null) {
            logger.e("Failed to find camera source");
            if (this.listener != null) {
                this.listener.onError(2);
            }
            Object object = this.stateLock;
            synchronized (object) {
                this.state = State.IDLE;
            }
            return false;
        }
        this.webRtcCameraCapturer = new Camera1Capturer(deviceName, this.cameraEventsHandler, false);
        return true;
    }

    private byte[] alignPicture(@NonNull Camera.CameraInfo info, @NonNull byte[] pictureData) {
        Bitmap bitmap = null;
        if (Build.VERSION.SDK_INT >= 28) {
            ByteBuffer buffer = ByteBuffer.wrap(pictureData);
            ImageDecoder.Source src = ImageDecoder.createSource((ByteBuffer)buffer);
            try {
                bitmap = ImageDecoder.decodeBitmap((ImageDecoder.Source)src);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            bitmap = BitmapFactory.decodeByteArray((byte[])pictureData, (int)0, (int)pictureData.length);
        }
        if (bitmap != null) {
            int degree = this.getFrameOrientation(info);
            Matrix matrix = new Matrix();
            if (this.cameraSource == CameraSource.FRONT_CAMERA) {
                switch (degree) {
                    case 0: 
                    case 180: {
                        matrix.setScale(-1.0f, 1.0f);
                        break;
                    }
                    case 90: 
                    case 270: {
                        matrix.setScale(1.0f, -1.0f);
                        break;
                    }
                }
            }
            matrix.postRotate((float)degree);
            Bitmap rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            rotatedBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
            return stream.toByteArray();
        }
        logger.e("Failed to align picture data. Returning original image.");
        return pictureData;
    }

    private int getFrameOrientation(@NonNull Camera.CameraInfo info) {
        int rotation = this.getDeviceOrientation();
        if (info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (info.orientation + rotation) % 360;
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCameraParametersOnCameraThread(@NonNull CameraParameterUpdater cameraParameterUpdater) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                this.camera1Session.checkIsOnCameraThread();
                Camera.Parameters cameraParameters = this.camera1Session.camera.getParameters();
                logger.i("Applying camera parameters");
                cameraParameterUpdater.apply(cameraParameters);
                this.camera1Session.camera.stopPreview();
                this.camera1Session.camera.setPreviewCallbackWithBuffer(null);
                this.camera1Session.camera.setParameters(cameraParameters);
                int frameSize = this.camera1Session.captureFormat.frameSize();
                for (int i = 0; i < 3; ++i) {
                    ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                    this.camera1Session.camera.addCallbackBuffer(buffer.array());
                }
                this.camera1Session.listenForBytebufferFrames();
                this.camera1Session.camera.startPreview();
            } else {
                logger.w("Attempted to update camera parameters while camera capturer is not running");
            }
            this.parameterUpdatePending.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takePictureOnCameraThread(@NonNull Handler pictureListenerHandler, @NonNull PictureListener pictureListener) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.RUNNING) {
                this.camera1Session.checkIsOnCameraThread();
                Camera.CameraInfo info = this.camera1Session.info;
                this.camera1Session.camera.takePicture(() -> pictureListenerHandler.post(pictureListener::onShutter), null, (pictureData, camera) -> {
                    byte[] alignedPictureData = this.alignPicture(info, pictureData);
                    pictureListenerHandler.post(() -> {
                        pictureListener.onPictureTaken(alignedPictureData);
                        this.picturePending.set(false);
                    });
                    Object object = this.stateLock;
                    synchronized (object) {
                        if (this.state == State.RUNNING) {
                            this.camera1Session.camera.startPreview();
                        }
                    }
                });
            } else {
                logger.w("Attempted to take picture while capturing is not running");
            }
        }
    }

    public static interface PictureListener {
        public void onShutter();

        public void onPictureTaken(@NonNull byte[] var1);
    }

    public static interface Listener {
        public void onFirstFrameAvailable();

        public void onCameraSwitched();

        public void onError(int var1);
    }

    private static enum State {
        IDLE,
        STARTING,
        RUNNING,
        STOPPING;

    }

    public static enum CameraSource {
        FRONT_CAMERA,
        BACK_CAMERA;

    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Error {
    }
}

