/*
 * Decompiled with CFR 0.152.
 */
package tvi.webrtc;

import tvi.webrtc.JNINamespace;
import tvi.webrtc.VideoCapturer;
import tvi.webrtc.VideoFrame;

@JNINamespace(value="webrtc::jni")
class AndroidVideoTrackSourceObserver
implements VideoCapturer.CapturerObserver {
    private final long nativeSource;

    public AndroidVideoTrackSourceObserver(long nativeSource) {
        this.nativeSource = nativeSource;
    }

    @Override
    public void onCapturerStarted(boolean success) {
        AndroidVideoTrackSourceObserver.nativeCapturerStarted(this.nativeSource, success);
    }

    @Override
    public void onCapturerStopped() {
        AndroidVideoTrackSourceObserver.nativeCapturerStopped(this.nativeSource);
    }

    @Override
    public void onByteBufferFrameCaptured(byte[] data, int width, int height, int rotation, long timeStamp) {
        AndroidVideoTrackSourceObserver.nativeOnByteBufferFrameCaptured(this.nativeSource, data, data.length, width, height, rotation, timeStamp);
    }

    @Override
    public void onTextureFrameCaptured(int width, int height, int oesTextureId, float[] transformMatrix, int rotation, long timestamp) {
        AndroidVideoTrackSourceObserver.nativeOnTextureFrameCaptured(this.nativeSource, width, height, oesTextureId, transformMatrix, rotation, timestamp);
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        AndroidVideoTrackSourceObserver.nativeOnFrameCaptured(this.nativeSource, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs(), frame.getBuffer());
    }

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeOnByteBufferFrameCaptured(long var0, byte[] var2, int var3, int var4, int var5, int var6, long var7);

    private static native void nativeOnTextureFrameCaptured(long var0, int var2, int var3, int var4, float[] var5, int var6, long var7);

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, VideoFrame.Buffer var7);
}

