/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.Preconditions;

@VisibleForTesting(otherwise=5)
class MediaOptions {
    private final boolean enableH264;
    @Nullable
    private final String audioFilePath;

    private MediaOptions(Builder builder) {
        this.enableH264 = builder.enableH264;
        this.audioFilePath = builder.audioFilePath;
    }

    static class Builder {
        private boolean enableH264;
        @Nullable
        private String audioFilePath;

        Builder() {
        }

        Builder enableH264(boolean enableH264) {
            this.enableH264 = enableH264;
            return this;
        }

        Builder audioFilePath(@NonNull String audioFilePath) {
            Preconditions.checkNotNull("audioFilePath should not be null", audioFilePath);
            this.audioFilePath = audioFilePath;
            return this;
        }

        MediaOptions build() {
            return new MediaOptions(this);
        }
    }
}

