/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.DataTrack;
import com.twilio.video.DataTrackOptions;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import java.nio.ByteBuffer;

public class LocalDataTrack
extends DataTrack {
    private static final Logger logger = Logger.getLogger(LocalDataTrack.class);
    private long nativeLocalDataTrackHandle;
    private final String nativeTrackHash;
    private final MediaFactory mediaFactory;

    @Nullable
    public static LocalDataTrack create(@NonNull Context context) {
        return LocalDataTrack.create(context, DataTrackOptions.DEFAULT_DATA_TRACK_OPTIONS);
    }

    @Nullable
    public static LocalDataTrack create(@NonNull Context context, @Nullable DataTrackOptions dataTrackOptions) {
        Preconditions.checkNotNull(context, "Context must not be null");
        dataTrackOptions = dataTrackOptions == null ? DataTrackOptions.DEFAULT_DATA_TRACK_OPTIONS : dataTrackOptions;
        Object temporaryMediaFactoryOwner = new Object();
        MediaFactory mediaFactory = MediaFactory.instance(temporaryMediaFactoryOwner, context);
        LocalDataTrack localDataTrack = mediaFactory.createDataTrack(context, dataTrackOptions.ordered, dataTrackOptions.maxPacketLifeTime, dataTrackOptions.maxRetransmits, dataTrackOptions.name);
        mediaFactory.release(temporaryMediaFactoryOwner);
        return localDataTrack;
    }

    public synchronized void send(@NonNull ByteBuffer messageBuffer) {
        Preconditions.checkState(!this.isReleased(), "Cannot send message after data track is released");
        Preconditions.checkNotNull(messageBuffer, "Message buffer must not be null");
        this.nativeBufferSend(this.nativeLocalDataTrackHandle, messageBuffer.hasArray() ? messageBuffer.array() : this.getMessageByteArray(messageBuffer));
    }

    public synchronized void send(@NonNull String message) {
        Preconditions.checkState(!this.isReleased(), "Cannot send message after data track is released");
        Preconditions.checkNotNull(message, "Message buffer must not be null");
        this.nativeStringSend(this.nativeLocalDataTrackHandle, message);
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return super.isEnabled();
        }
        logger.e("Local data track is not enabled because it has been released");
        return false;
    }

    @Override
    @NonNull
    public String getName() {
        return super.getName();
    }

    public synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalDataTrackHandle);
            this.nativeLocalDataTrackHandle = 0L;
            this.mediaFactory.release(this);
        }
    }

    LocalDataTrack(long nativeLocalDataTrackHandle, boolean enabled, boolean ordered, boolean reliable, int maxPacketLifeTime, int maxRetransmits, String nativeTrackHash, String name, Context context) {
        super(enabled, ordered, reliable, maxPacketLifeTime, maxRetransmits, name);
        this.nativeLocalDataTrackHandle = nativeLocalDataTrackHandle;
        this.nativeTrackHash = nativeTrackHash;
        this.mediaFactory = MediaFactory.instance(this, context);
    }

    boolean isReleased() {
        return this.nativeLocalDataTrackHandle == 0L;
    }

    String getNativeTrackHash() {
        return this.nativeTrackHash;
    }

    synchronized long getNativeHandle() {
        return this.nativeLocalDataTrackHandle;
    }

    private byte[] getMessageByteArray(ByteBuffer messageBuffer) {
        byte[] messageByteArray = new byte[messageBuffer.capacity()];
        messageBuffer.get(messageByteArray);
        return messageByteArray;
    }

    private native void nativeBufferSend(long var1, byte[] var3);

    private native void nativeStringSend(long var1, String var3);

    private native void nativeRelease(long var1);
}

