/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.MediaStreamTrack;

public class RtpParameters {
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    public RtpParameters() {
        this.encodings = new ArrayList<Encoding>();
        this.codecs = new ArrayList<Codec>();
    }

    @CalledByNative
    RtpParameters(List<Encoding> encodings, List<Codec> codecs) {
        this.encodings = encodings;
        this.codecs = codecs;
    }

    @CalledByNative
    List<Encoding> getEncodings() {
        return this.encodings;
    }

    @CalledByNative
    List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class Codec {
        public int payloadType;
        public String name;
        MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;

        @CalledByNative(value="Codec")
        Codec(int payloadType, String name, MediaStreamTrack.MediaType kind, Integer clockRate, Integer numChannels) {
            this.payloadType = payloadType;
            this.name = name;
            this.kind = kind;
            this.clockRate = clockRate;
            this.numChannels = numChannels;
        }

        @CalledByNative(value="Codec")
        int getPayloadType() {
            return this.payloadType;
        }

        @CalledByNative(value="Codec")
        String getName() {
            return this.name;
        }

        @CalledByNative(value="Codec")
        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        @CalledByNative(value="Codec")
        Integer getClockRate() {
            return this.clockRate;
        }

        @CalledByNative(value="Codec")
        Integer getNumChannels() {
            return this.numChannels;
        }
    }

    public static class Encoding {
        public boolean active = true;
        @Nullable
        public Integer maxBitrateBps;
        public Long ssrc;

        @CalledByNative(value="Encoding")
        Encoding(boolean active, Integer maxBitrateBps, Long ssrc) {
            this.active = active;
            this.maxBitrateBps = maxBitrateBps;
            this.ssrc = ssrc;
        }

        @CalledByNative(value="Encoding")
        boolean getActive() {
            return this.active;
        }

        @Nullable
        @CalledByNative(value="Encoding")
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @CalledByNative(value="Encoding")
        Long getSsrc() {
            return this.ssrc;
        }
    }
}

