/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.AudioOptions;
import com.twilio.video.AudioTrack;
import com.twilio.video.Logger;
import com.twilio.video.MediaFactory;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;

public class LocalAudioTrack
extends AudioTrack {
    private static final Logger logger = Logger.getLogger(LocalAudioTrack.class);
    private final String nativeTrackHash;
    private final MediaFactory mediaFactory;
    private long nativeLocalAudioTrackHandle;

    @Nullable
    public static LocalAudioTrack create(@NonNull Context context, boolean enabled) {
        return LocalAudioTrack.create(context, enabled, null, null);
    }

    @Nullable
    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @Nullable AudioOptions audioOptions) {
        return LocalAudioTrack.create(context, enabled, audioOptions, null);
    }

    @Nullable
    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @Nullable String name) {
        return LocalAudioTrack.create(context, enabled, null, name);
    }

    @Nullable
    public static LocalAudioTrack create(@NonNull Context context, boolean enabled, @Nullable AudioOptions audioOptions, @Nullable String name) {
        Preconditions.checkNotNull(context);
        Preconditions.checkState(Util.permissionGranted(context, "android.permission.RECORD_AUDIO"), "RECORD_AUDIO permission must be granted to create audio track");
        Object temporaryMediaFactoryOwner = new Object();
        MediaFactory mediaFactory = MediaFactory.instance(temporaryMediaFactoryOwner, context);
        LocalAudioTrack localAudioTrack = mediaFactory.createAudioTrack(context, enabled, audioOptions, name);
        if (localAudioTrack == null) {
            logger.e("Failed to create local audio track");
        }
        mediaFactory.release(temporaryMediaFactoryOwner);
        return localAudioTrack;
    }

    @Override
    public synchronized boolean isEnabled() {
        if (!this.isReleased()) {
            return this.nativeIsEnabled(this.nativeLocalAudioTrackHandle);
        }
        logger.w("Local audio track is not enabled because it has been released");
        return false;
    }

    @Override
    public String getName() {
        return super.getName();
    }

    public synchronized void enable(boolean enable) {
        if (!this.isReleased()) {
            this.nativeEnable(this.nativeLocalAudioTrackHandle, enable);
        } else {
            logger.e("Cannot enable a local audio track that has been removed");
        }
    }

    @Override
    public synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeLocalAudioTrackHandle);
            this.nativeLocalAudioTrackHandle = 0L;
            this.mediaFactory.release(this);
        }
    }

    LocalAudioTrack(long nativeLocalAudioTrackHandle, @NonNull String nativeTrackHash, @NonNull String name, boolean enabled, Context context) {
        super(nativeLocalAudioTrackHandle, enabled, name);
        this.nativeTrackHash = nativeTrackHash;
        this.nativeLocalAudioTrackHandle = nativeLocalAudioTrackHandle;
        this.mediaFactory = MediaFactory.instance(this, context);
    }

    boolean isReleased() {
        return this.nativeLocalAudioTrackHandle == 0L;
    }

    String getNativeTrackHash() {
        return this.nativeTrackHash;
    }

    synchronized long getNativeHandle() {
        return this.nativeLocalAudioTrackHandle;
    }

    private native boolean nativeIsEnabled(long var1);

    private native void nativeEnable(long var1, boolean var3);

    private native void nativeRelease(long var1);
}

