/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import com.twilio.video.I420Frame;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Track;
import com.twilio.video.VideoRenderer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.webrtc.VideoRenderer;

public abstract class VideoTrack
implements Track {
    private static final Logger logger = Logger.getLogger(VideoTrack.class);
    private Map<VideoRenderer, org.webrtc.VideoRenderer> videoRenderersMap = new HashMap<VideoRenderer, org.webrtc.VideoRenderer>();
    private final org.webrtc.VideoTrack webRtcVideoTrack;
    private final String name;
    private boolean isEnabled;
    private boolean isReleased = false;

    VideoTrack(org.webrtc.VideoTrack webRtcVideoTrack, boolean enabled, @NonNull String name) {
        this.isEnabled = enabled;
        this.name = name;
        this.webRtcVideoTrack = webRtcVideoTrack;
    }

    public synchronized void addRenderer(@NonNull VideoRenderer videoRenderer) {
        Preconditions.checkNotNull(videoRenderer, "Video renderer must not be null");
        if (!this.isReleased) {
            org.webrtc.VideoRenderer webrtcVideoRenderer = this.createWebRtcVideoRenderer(videoRenderer);
            this.videoRenderersMap.put(videoRenderer, webrtcVideoRenderer);
            if (this.webRtcVideoTrack != null) {
                this.webRtcVideoTrack.addRenderer(webrtcVideoRenderer);
            }
        } else {
            logger.w("Attempting to add renderer to track that has been removed");
        }
    }

    public synchronized void removeRenderer(@NonNull VideoRenderer videoRenderer) {
        Preconditions.checkNotNull(videoRenderer, "Video renderer must not be null");
        if (!this.isReleased) {
            org.webrtc.VideoRenderer webrtcVideoRenderer = this.videoRenderersMap.remove(videoRenderer);
            if (this.webRtcVideoTrack != null && webrtcVideoRenderer != null) {
                this.webRtcVideoTrack.removeRenderer(webrtcVideoRenderer);
            }
        } else {
            logger.w("Attempting to remove renderer from track that has been removed");
        }
    }

    @NonNull
    public synchronized List<VideoRenderer> getRenderers() {
        return new ArrayList<VideoRenderer>(this.videoRenderersMap.keySet());
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public String getName() {
        return this.name;
    }

    synchronized void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    synchronized void release() {
        if (!this.isReleased) {
            this.invalidateWebRtcTrack();
            this.videoRenderersMap.clear();
            this.isReleased = true;
        }
    }

    synchronized void invalidateWebRtcTrack() {
        if (this.webRtcVideoTrack != null) {
            for (Map.Entry<VideoRenderer, org.webrtc.VideoRenderer> entry : this.videoRenderersMap.entrySet()) {
                this.webRtcVideoTrack.removeRenderer(entry.getValue());
            }
        }
    }

    @VisibleForTesting(otherwise=2)
    synchronized org.webrtc.VideoTrack getWebRtcTrack() {
        return this.webRtcVideoTrack;
    }

    private org.webrtc.VideoRenderer createWebRtcVideoRenderer(VideoRenderer videoRenderer) {
        return new org.webrtc.VideoRenderer((VideoRenderer.Callbacks)new VideoRendererCallbackAdapter(videoRenderer));
    }

    private class VideoRendererCallbackAdapter
    implements VideoRenderer.Callbacks {
        private final VideoRenderer videoRenderer;

        VideoRendererCallbackAdapter(VideoRenderer videoRenderer) {
            this.videoRenderer = videoRenderer;
        }

        public void renderFrame(VideoRenderer.I420Frame frame) {
            this.videoRenderer.renderFrame(new I420Frame(frame));
        }
    }
}

