/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.VideoDimensions;

public class VideoFrame {
    final org.webrtc.VideoFrame webRtcVideoFrame;
    public final byte[] imageBuffer;
    public final VideoDimensions dimensions;
    public final RotationAngle orientation;
    public final long timestamp;

    public VideoFrame(byte[] imageBuffer, @NonNull VideoDimensions dimensions, @NonNull RotationAngle orientation, long timestamp) {
        this(imageBuffer, null, dimensions, orientation, timestamp);
    }

    VideoFrame(org.webrtc.VideoFrame webRtcVideoFrame, @NonNull VideoDimensions dimensions, @NonNull RotationAngle orientation) {
        this(null, webRtcVideoFrame, dimensions, orientation, webRtcVideoFrame.getTimestampNs());
    }

    private VideoFrame(@Nullable byte[] imageBuffer, @Nullable org.webrtc.VideoFrame webRtcVideoFrame, @NonNull VideoDimensions dimensions, @NonNull RotationAngle orientation, long timestamp) {
        this.imageBuffer = imageBuffer;
        this.webRtcVideoFrame = webRtcVideoFrame;
        this.dimensions = dimensions;
        this.orientation = orientation;
        this.timestamp = timestamp;
    }

    public static enum RotationAngle {
        ROTATION_0(0),
        ROTATION_90(90),
        ROTATION_180(180),
        ROTATION_270(270);

        private final int rotation;

        private RotationAngle(int rotation) {
            this.rotation = rotation;
        }

        public int getValue() {
            return this.rotation;
        }

        public static RotationAngle fromInt(int rotation) {
            if (rotation == 0) {
                return ROTATION_0;
            }
            if (rotation == 90) {
                return ROTATION_90;
            }
            if (rotation == 180) {
                return ROTATION_180;
            }
            if (rotation == 270) {
                return ROTATION_270;
            }
            throw new IllegalArgumentException("Orientation value must be 0, 90, 180 or 270: " + rotation);
        }
    }
}

