/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import com.twilio.video.VideoFrame;
import com.twilio.video.VideoPixelFormat;
import java.util.ArrayList;
import java.util.List;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

@TargetApi(value=21)
public class ScreenCapturer
implements VideoCapturer {
    private static final Logger logger = Logger.getLogger(ScreenCapturer.class);
    private static final int SCREENCAPTURE_FRAME_RATE = 30;
    private boolean firstFrameReported;
    private final Context context;
    private final Intent screenCaptureIntentData;
    private final Listener screenCapturerListener;
    private final int screenCaptureIntentResult;
    private final Handler listenerHandler;
    private VideoCapturer.Listener capturerListener;
    private ScreenCapturerAndroid webRtcScreenCapturer;
    private SurfaceTextureHelper surfaceTextureHelper;
    private final MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
            logger.d("media projection stopped");
        }
    };
    private final VideoCapturer.CapturerObserver observerAdapter = new VideoCapturer.CapturerObserver(){

        public void onCapturerStarted(boolean success) {
            logger.d("screen capturer started");
            if (!success && ScreenCapturer.this.screenCapturerListener != null) {
                ScreenCapturer.this.listenerHandler.post(() -> ScreenCapturer.this.screenCapturerListener.onScreenCaptureError("Failed to start screen capturer"));
            }
            ScreenCapturer.this.capturerListener.onCapturerStarted(success);
        }

        public void onCapturerStopped() {
            logger.d("screen capturer stopped");
        }

        public void onFrameCaptured(org.webrtc.VideoFrame videoFrame) {
            if (!ScreenCapturer.this.firstFrameReported) {
                if (ScreenCapturer.this.screenCapturerListener != null) {
                    ScreenCapturer.this.listenerHandler.post(ScreenCapturer.this.screenCapturerListener::onFirstFrameAvailable);
                }
                ScreenCapturer.this.firstFrameReported = true;
            }
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            VideoDimensions dimensions = new VideoDimensions(buffer.getWidth(), buffer.getHeight());
            VideoFrame.RotationAngle orientation = VideoFrame.RotationAngle.fromInt(videoFrame.getRotation());
            ScreenCapturer.this.capturerListener.onFrameCaptured(new VideoFrame(videoFrame, dimensions, orientation));
        }
    };

    public ScreenCapturer(@NonNull Context context, int screenCaptureIntentResult, @NonNull Intent screenCaptureIntentData, @Nullable Listener screenCapturerListener) {
        Preconditions.checkState(Build.VERSION.SDK_INT >= 21, "Screen capturing unavailable for " + Build.VERSION.SDK_INT);
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(screenCaptureIntentData, "intent must not be null");
        this.context = context;
        this.screenCaptureIntentData = screenCaptureIntentData;
        this.screenCaptureIntentResult = screenCaptureIntentResult;
        this.screenCapturerListener = screenCapturerListener;
        this.listenerHandler = Util.createCallbackHandler();
    }

    @Override
    public synchronized List<VideoFormat> getSupportedFormats() {
        ArrayList<VideoFormat> screencastFormats = new ArrayList<VideoFormat>();
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        VideoDimensions screenDimensions = new VideoDimensions(displayMetrics.widthPixels, displayMetrics.heightPixels);
        screencastFormats.add(new VideoFormat(screenDimensions, 30, VideoPixelFormat.RGBA_8888));
        return screencastFormats;
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    @Override
    public void startCapture(VideoFormat captureFormat, VideoCapturer.Listener capturerListener) {
        this.capturerListener = capturerListener;
        this.firstFrameReported = false;
        if (this.screenCaptureIntentResult != -1) {
            if (this.screenCapturerListener != null) {
                this.listenerHandler.post(() -> this.screenCapturerListener.onScreenCaptureError("MediaProjection permissions must be granted to start ScreenCapturer"));
            }
            capturerListener.onCapturerStarted(false);
            return;
        }
        this.webRtcScreenCapturer = new ScreenCapturerAndroid(this.screenCaptureIntentData, this.mediaProjectionCallback);
        this.webRtcScreenCapturer.initialize(this.surfaceTextureHelper, this.context, this.observerAdapter);
        this.webRtcScreenCapturer.startCapture(captureFormat.dimensions.width, captureFormat.dimensions.height, captureFormat.framerate);
    }

    @Override
    public void stopCapture() {
        logger.d("stopCapture");
        if (this.webRtcScreenCapturer != null) {
            this.webRtcScreenCapturer.stopCapture();
            this.webRtcScreenCapturer.dispose();
            this.webRtcScreenCapturer = null;
        }
        logger.d("stopCapture done");
    }

    void setSurfaceTextureHelper(SurfaceTextureHelper surfaceTextureHelper) {
        this.surfaceTextureHelper = surfaceTextureHelper;
    }

    public static interface Listener {
        public void onScreenCaptureError(String var1);

        public void onFirstFrameAvailable();
    }
}

