/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import android.support.annotation.Nullable;
import com.twilio.video.DataTrack;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import java.nio.ByteBuffer;

public class RemoteDataTrack
extends DataTrack {
    private static final Logger logger = Logger.getLogger(RemoteDataTrack.class);
    private final String sid;
    private long nativeRemoteDataTrackContext;
    private Handler handler;
    private Listener listener;
    private final Listener dataTrackListenerProxy = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(final RemoteDataTrack remoteDataTrack, final ByteBuffer messageBuffer) {
            this.checkCallback(messageBuffer, "onMessage(ByteBuffer)");
            RemoteDataTrack remoteDataTrack2 = RemoteDataTrack.this;
            synchronized (remoteDataTrack2) {
                if (RemoteDataTrack.this.handler != null) {
                    RemoteDataTrack.this.handler.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            RemoteDataTrack remoteDataTrack2 = RemoteDataTrack.this;
                            synchronized (remoteDataTrack2) {
                                logger.d("onMessage(ByteBuffer)");
                                if (RemoteDataTrack.this.listener != null) {
                                    RemoteDataTrack.this.listener.onMessage(remoteDataTrack, messageBuffer);
                                }
                            }
                        }
                    });
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMessage(final RemoteDataTrack remoteDataTrack, final String message) {
            this.checkCallback(message, "onMessage(String)");
            RemoteDataTrack remoteDataTrack2 = RemoteDataTrack.this;
            synchronized (remoteDataTrack2) {
                if (RemoteDataTrack.this.handler != null) {
                    RemoteDataTrack.this.handler.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            RemoteDataTrack remoteDataTrack2 = RemoteDataTrack.this;
                            synchronized (remoteDataTrack2) {
                                logger.d("onMessage(String)");
                                if (RemoteDataTrack.this.listener != null) {
                                    RemoteDataTrack.this.listener.onMessage(remoteDataTrack, message);
                                }
                            }
                        }
                    });
                }
            }
        }

        private void checkCallback(Object message, String callback) {
            Preconditions.checkNotNull(message, "Received null message in %s", (Object)callback);
        }
    };

    public String getSid() {
        return this.sid;
    }

    public synchronized void setListener(@Nullable Listener listener) {
        this.handler = listener != null ? Util.createCallbackHandler() : null;
        this.listener = listener;
    }

    RemoteDataTrack(boolean enabled, boolean ordered, boolean reliable, int maxPacketLifeTime, int maxRetransmits, String sid, String name, long nativeRemoteDataTrackContext) {
        super(enabled, ordered, reliable, maxPacketLifeTime, maxRetransmits, name);
        this.sid = sid;
        this.nativeRemoteDataTrackContext = nativeRemoteDataTrackContext;
    }

    synchronized void release() {
        if (!this.isReleased()) {
            this.nativeRelease(this.nativeRemoteDataTrackContext);
            this.nativeRemoteDataTrackContext = 0L;
        }
    }

    boolean isReleased() {
        return this.nativeRemoteDataTrackContext == 0L;
    }

    private native void nativeRelease(long var1);

    public static interface Listener {
        public void onMessage(RemoteDataTrack var1, ByteBuffer var2);

        public void onMessage(RemoteDataTrack var1, String var2);
    }
}

