/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.twilio.video.AudioTrack;
import com.twilio.video.AudioTrackPublication;
import com.twilio.video.RemoteAudioTrack;

public class RemoteAudioTrackPublication
implements AudioTrackPublication {
    private final String sid;
    private final String name;
    private RemoteAudioTrack remoteAudioTrack;
    private boolean subscribed;
    private boolean enabled;

    RemoteAudioTrackPublication(boolean subscribed, boolean enabled, @NonNull String sid, @NonNull String name) {
        this.subscribed = subscribed;
        this.sid = sid;
        this.name = name;
        this.enabled = enabled;
    }

    @Override
    public String getTrackSid() {
        return this.sid;
    }

    @Override
    @Nullable
    public synchronized AudioTrack getAudioTrack() {
        return this.remoteAudioTrack;
    }

    @Override
    public String getTrackName() {
        return this.name;
    }

    @Override
    public synchronized boolean isTrackEnabled() {
        return this.enabled;
    }

    public synchronized boolean isTrackSubscribed() {
        return this.subscribed;
    }

    @Nullable
    public synchronized RemoteAudioTrack getRemoteAudioTrack() {
        return this.remoteAudioTrack;
    }

    synchronized void setSubscribed(boolean subscribed) {
        this.subscribed = subscribed;
    }

    synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.remoteAudioTrack != null) {
            this.remoteAudioTrack.setEnabled(enabled);
        }
    }

    synchronized void setRemoteAudioTrack(RemoteAudioTrack remoteAudioTrack) {
        this.remoteAudioTrack = remoteAudioTrack;
    }
}

