/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.Preconditions;

public class DataTrackOptions {
    public static final int DEFAULT_MAX_PACKET_LIFE_TIME = -1;
    public static final int DEFAULT_MAX_RETRANSMITS = -1;
    public static final DataTrackOptions DEFAULT_DATA_TRACK_OPTIONS = new Builder().ordered(true).maxPacketLifeTime(-1).maxRetransmits(-1).build();
    final boolean ordered;
    final int maxPacketLifeTime;
    final int maxRetransmits;

    private DataTrackOptions(Builder builder) {
        this.ordered = builder.ordered;
        this.maxPacketLifeTime = builder.maxPacketLifeTime;
        this.maxRetransmits = builder.maxRetransmits;
    }

    public static class Builder {
        private boolean ordered = true;
        private int maxPacketLifeTime = -1;
        private int maxRetransmits = -1;

        public Builder ordered(boolean ordered) {
            this.ordered = ordered;
            return this;
        }

        public Builder maxPacketLifeTime(int maxPacketLifeTime) {
            this.maxPacketLifeTime = maxPacketLifeTime;
            return this;
        }

        public Builder maxRetransmits(int maxRetransmits) {
            this.maxRetransmits = maxRetransmits;
            return this;
        }

        public DataTrackOptions build() {
            Preconditions.checkArgument(this.maxPacketLifeTime >= -1);
            Preconditions.checkArgument(this.maxPacketLifeTime <= 65535);
            Preconditions.checkArgument(this.maxRetransmits >= -1);
            Preconditions.checkArgument(this.maxRetransmits <= 65535);
            Preconditions.checkState(this.maxRetransmits == -1 || this.maxPacketLifeTime == -1);
            return new DataTrackOptions(this);
        }
    }
}

